/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.azure;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="azure-port-range")
@ApplicableTo(value={PropertyKind.STRING})
public @interface PortRange {
    public static final String DEFAULT_MESSAGE = "Port '%s' is not valid";

    public String message() default "Port '%s' is not valid";

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        private String message = "Port '%s' is not valid";

        public void validate(String value, ValidationContext context) {
            if (value == null) {
                return;
            }
            if (!Validator.isValidPort(value)) {
                context.error(this.message, new Object[]{value});
            }
        }

        static boolean isValidPort(String port) {
            if (port.equals("*")) {
                return true;
            }
            try {
                int portInt = Integer.parseInt(port);
                return portInt >= 0 && portInt <= 65535;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

