/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.signaturescanner.command;

import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanCommandQuoteParser;
import com.synopsys.integration.blackduck.exception.MismatchedQuotesException;
import com.synopsys.integration.blackduck.exception.SignatureScannerInputException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ScanCommandArgumentParser {
    public List<String> parse(String command) throws SignatureScannerInputException {
        if (!this.isParseable(command)) {
            return new LinkedList<String>();
        }
        LinkedList<String> parsedArguments = new LinkedList<String>();
        String[] splitBySpaces = command.split("\\s");
        boolean inQuotes = false;
        StringBuilder quotedArgument = null;
        for (String text : splitBySpaces) {
            if (text.startsWith("\"") && !inQuotes) {
                inQuotes = true;
                quotedArgument = new StringBuilder();
            }
            if (inQuotes) {
                if (quotedArgument.length() > 0) {
                    quotedArgument.append(" ");
                }
                quotedArgument.append(text);
                if (!text.endsWith("\"") || text.endsWith("\\\"")) continue;
                inQuotes = false;
                parsedArguments.add(quotedArgument.toString());
                continue;
            }
            parsedArguments.add(text);
        }
        this.validateParsedArguments(parsedArguments, command);
        return parsedArguments;
    }

    private boolean isParseable(String command) throws SignatureScannerInputException {
        if (StringUtils.isBlank((CharSequence)command)) {
            return false;
        }
        this.validateCommand(command);
        return true;
    }

    private void validateCommand(String command) throws SignatureScannerInputException {
        ScanCommandQuoteParser quoteParser = new ScanCommandQuoteParser();
        if (!quoteParser.hasEvenNumberOfNonEscapedQuotes(command)) {
            throw new MismatchedQuotesException(String.format("Unable to parse signature scanner arguments due to unbalanced quotes in command: %s", command));
        }
    }

    private void validateParsedArguments(List<String> parsedArguments, String command) throws SignatureScannerInputException {
        String originalCheck = StringUtils.join(parsedArguments, (String)" ");
        if (!originalCheck.equals(command)) {
            throw new SignatureScannerInputException("Unable to parse signature scanner arguments.  Please check your input for improper syntax, such as trailing spaces.");
        }
    }
}

