/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.signaturescanner.command;

import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.BlackDuckOnlineProperties;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.IndividualFileMatching;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanCommandArgumentParser;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanPaths;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ScanCommand {
    private final String scheme;
    private final String host;
    private final int port;
    private final String targetPath;
    private final String name;
    private final Set<String> excludePatterns;
    private final BlackDuckOnlineProperties blackDuckOnlineProperties;
    private final String blackDuckUsername;
    private final String blackDuckPassword;
    private final String blackDuckApiToken;
    private final File signatureScannerInstallDirectory;
    private final File outputDirectory;
    private final int scanMemoryInMegabytes;
    private final String scanCliOpts;
    private final String additionalScanArguments;
    private final boolean runInsecure;
    private final boolean dryRun;
    private final ProxyInfo proxyInfo;
    private final String projectName;
    private final String versionName;
    private final IndividualFileMatching individualFileMatching;
    private final boolean debug;
    private final boolean verbose;

    public ScanCommand(File signatureScannerInstallDirectory, File outputDirectory, boolean dryRun, ProxyInfo proxyInfo, String scanCliOpts, int scanMemoryInMegabytes, String scheme, String host, String blackDuckApiToken, String blackDuckUsername, String blackDuckPassword, int port, boolean runInsecure, String name, BlackDuckOnlineProperties blackDuckOnlineProperties, IndividualFileMatching individualFileMatching, Set<String> excludePatterns, String additionalScanArguments, String targetPath, boolean verbose, boolean debug, String projectName, String versionName) {
        this.signatureScannerInstallDirectory = signatureScannerInstallDirectory;
        this.outputDirectory = outputDirectory;
        this.dryRun = dryRun;
        this.proxyInfo = proxyInfo;
        this.scanCliOpts = scanCliOpts;
        this.scanMemoryInMegabytes = scanMemoryInMegabytes;
        this.scheme = scheme;
        this.host = host;
        this.blackDuckApiToken = blackDuckApiToken;
        this.blackDuckUsername = blackDuckUsername;
        this.blackDuckPassword = blackDuckPassword;
        this.port = port;
        this.runInsecure = runInsecure;
        this.name = name;
        this.blackDuckOnlineProperties = blackDuckOnlineProperties;
        this.individualFileMatching = individualFileMatching;
        this.excludePatterns = excludePatterns;
        this.additionalScanArguments = additionalScanArguments;
        this.targetPath = targetPath;
        this.verbose = verbose;
        this.debug = debug;
        this.projectName = projectName;
        this.versionName = versionName;
    }

    public List<String> createCommandForProcessBuilder(IntLogger logger, ScanPaths scannerPaths, String specificRunOutputDirectoryPath) throws IllegalArgumentException, IntegrationException {
        ArrayList<String> cmd = new ArrayList<String>();
        logger.debug("Using this java installation : " + scannerPaths.getPathToJavaExecutable());
        scannerPaths.addJavaAndOnePathArguments(cmd);
        if (this.proxyInfo.shouldUseProxy()) {
            this.populateProxyDetails(cmd);
        }
        this.populateScanCliOpts(cmd);
        cmd.add("-Xmx" + this.scanMemoryInMegabytes + "m");
        scannerPaths.addScanExecutableArguments(cmd);
        cmd.add("--no-prompt");
        if (!this.dryRun) {
            this.populateOnlineProperties(logger, cmd);
        } else {
            this.populateOfflineProperties(logger, specificRunOutputDirectoryPath, cmd);
        }
        if (this.verbose) {
            cmd.add("-v");
        }
        if (this.debug) {
            cmd.add("--debug");
        }
        cmd.add("--logDir");
        cmd.add(specificRunOutputDirectoryPath);
        cmd.add("--statusWriteDir");
        cmd.add(specificRunOutputDirectoryPath);
        this.populateProjectAndVersion(cmd);
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            cmd.add("--name");
            cmd.add(this.name);
        }
        this.populateExcludePatterns(cmd);
        if (null != this.individualFileMatching) {
            cmd.add("--individualFileMatching=" + (Object)((Object)this.individualFileMatching));
        }
        ScanCommandArgumentParser parser = new ScanCommandArgumentParser();
        this.populateAdditionalScanArguments(cmd, parser);
        return cmd;
    }

    private void populateAdditionalScanArguments(List<String> cmd, ScanCommandArgumentParser parser) throws IntegrationException {
        List<String> arguments = parser.parse(this.additionalScanArguments);
        for (String argument : arguments) {
            if (!StringUtils.isNotBlank((CharSequence)argument)) continue;
            cmd.add(argument);
        }
    }

    private void populateExcludePatterns(List<String> cmd) {
        if (this.excludePatterns != null) {
            for (String exclusionPattern : this.excludePatterns) {
                if (!StringUtils.isNotBlank((CharSequence)exclusionPattern)) continue;
                cmd.add("--exclude");
                cmd.add(exclusionPattern);
            }
        }
    }

    private void populateProjectAndVersion(List<String> cmd) {
        if (StringUtils.isNotBlank((CharSequence)this.projectName) && StringUtils.isNotBlank((CharSequence)this.versionName)) {
            cmd.add("--project");
            cmd.add(this.projectName);
            cmd.add("--release");
            cmd.add(this.versionName);
        }
    }

    private void populateOfflineProperties(IntLogger logger, String specificRunOutputDirectoryPath, List<String> cmd) {
        logger.info("You have configured this signature scan to run in dry run mode - no results will be submitted to Black Duck.");
        this.blackDuckOnlineProperties.warnIfOnlineIsNeeded(logger::warn);
        cmd.add("--dryRunWriteDir");
        cmd.add(specificRunOutputDirectoryPath);
    }

    private void populateOnlineProperties(IntLogger logger, List<String> cmd) {
        int blackDuckPort;
        cmd.add("--scheme");
        cmd.add(this.scheme);
        cmd.add("--host");
        cmd.add(this.host);
        logger.debug("Using the Black Duck hostname : '" + this.host + "'");
        if (StringUtils.isEmpty((CharSequence)this.blackDuckApiToken)) {
            cmd.add("--username");
            cmd.add(this.blackDuckUsername);
        }
        if ((blackDuckPort = this.port) > 0) {
            cmd.add("--port");
            cmd.add(Integer.toString(blackDuckPort));
        } else {
            logger.warn("Could not find a port to use for the Server.");
        }
        if (this.runInsecure) {
            cmd.add("--insecure");
        }
        this.blackDuckOnlineProperties.addOnlineCommands(cmd);
    }

    private void populateScanCliOpts(List<String> cmd) {
        if (StringUtils.isNotBlank((CharSequence)this.scanCliOpts)) {
            for (String scanOpt : this.scanCliOpts.split(" ")) {
                if (!StringUtils.isNotBlank((CharSequence)scanOpt)) continue;
                cmd.add(scanOpt);
            }
        }
    }

    private void populateProxyDetails(List<String> cmd) {
        ProxyInfo blackDuckProxyInfo = this.proxyInfo;
        String proxyHost = blackDuckProxyInfo.getHost().orElse(null);
        int proxyPort = blackDuckProxyInfo.getPort();
        String proxyUsername = blackDuckProxyInfo.getUsername().orElse(null);
        String proxyPassword = blackDuckProxyInfo.getPassword().orElse(null);
        String proxyNtlmDomain = blackDuckProxyInfo.getNtlmDomain().orElse(null);
        String proxyNtlmWorkstation = blackDuckProxyInfo.getNtlmWorkstation().orElse(null);
        cmd.add("-Dhttp.proxyHost=" + proxyHost);
        cmd.add("-Dhttp.proxyPort=" + proxyPort);
        if (StringUtils.isNotBlank((CharSequence)proxyUsername) && StringUtils.isNotBlank((CharSequence)proxyPassword)) {
            cmd.add("-Dhttp.proxyUser=" + proxyUsername);
            cmd.add("-Dhttp.proxyPassword=" + proxyPassword);
        } else {
            cmd.add("-Dhttp.proxyUser=user");
            cmd.add("-Dhttp.proxyPassword=password");
        }
        if (StringUtils.isNotBlank((CharSequence)proxyNtlmDomain)) {
            cmd.add("-Dhttp.auth.ntlm.domain=" + proxyNtlmDomain);
        }
        if (StringUtils.isNotBlank((CharSequence)proxyNtlmWorkstation)) {
            cmd.add("-Dblackduck.http.auth.ntlm.workstation=" + proxyNtlmWorkstation);
        }
    }

    public File getSignatureScannerInstallDirectory() {
        return this.signatureScannerInstallDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public String getScanCliOpts() {
        return this.scanCliOpts;
    }

    public int getScanMemoryInMegabytes() {
        return this.scanMemoryInMegabytes;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public String getBlackDuckApiToken() {
        return this.blackDuckApiToken;
    }

    public String getBlackDuckUsername() {
        return this.blackDuckUsername;
    }

    public String getBlackDuckPassword() {
        return this.blackDuckPassword;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunInsecure() {
        return this.runInsecure;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSnippetMatching() {
        return this.blackDuckOnlineProperties.isSnippetMatching();
    }

    public boolean isSnippetMatchingOnly() {
        return this.blackDuckOnlineProperties.isSnippetMatchingOnly();
    }

    public boolean isFullSnippetScan() {
        return this.blackDuckOnlineProperties.isFullSnippetScan();
    }

    public boolean isUploadSource() {
        return this.blackDuckOnlineProperties.isUploadSource();
    }

    public boolean isLicenseSearch() {
        return this.blackDuckOnlineProperties.isLicenseSearch();
    }

    public boolean isCopyrightSearch() {
        return this.blackDuckOnlineProperties.isCopyrightSearch();
    }

    public IndividualFileMatching getIndividualFileMatching() {
        return this.individualFileMatching;
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public String getAdditionalScanArguments() {
        return this.additionalScanArguments;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getVersionName() {
        return this.versionName;
    }
}

