/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http.client.cache;

import com.synopsys.integration.blackduck.http.client.BlackDuckHttpClient;
import com.synopsys.integration.blackduck.http.client.cache.CacheableResponse;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.ErrorResponse;
import com.synopsys.integration.rest.response.Response;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class CachingHttpClient
implements BlackDuckHttpClient {
    private final BlackDuckHttpClient blackDuckHttpClient;
    private final LRUMap<Request, Response> cache;

    public CachingHttpClient(BlackDuckHttpClient blackDuckHttpClient) {
        this.blackDuckHttpClient = blackDuckHttpClient;
        this.cache = new LRUMap(1000);
    }

    public void emptyCache() {
        this.cache.clear();
    }

    @Override
    public Response execute(Request request) throws IntegrationException {
        if (HttpMethod.GET == request.getMethod() && this.cache.containsKey((Object)request)) {
            return (Response)this.cache.get((Object)request);
        }
        Response response = this.blackDuckHttpClient.execute(request);
        CacheableResponse cacheableResponse = new CacheableResponse(request, response, this.cache);
        return cacheableResponse;
    }

    @Override
    public Optional<Response> executeGetRequestIfModifiedSince(Request getRequest, long timeToCheck) throws IntegrationException, IOException {
        return this.blackDuckHttpClient.executeGetRequestIfModifiedSince(getRequest, timeToCheck);
    }

    @Override
    public Response attemptAuthentication() throws IntegrationException {
        return this.blackDuckHttpClient.attemptAuthentication();
    }

    @Override
    public boolean isAlreadyAuthenticated(HttpUriRequest request) {
        return this.blackDuckHttpClient.isAlreadyAuthenticated(request);
    }

    @Override
    public Optional<ErrorResponse> extractErrorResponse(String responseContent) {
        return this.blackDuckHttpClient.extractErrorResponse(responseContent);
    }

    @Override
    public void handleErrorResponse(HttpUriRequest request, Response response) {
        this.blackDuckHttpClient.handleErrorResponse(request, response);
    }

    @Override
    public void throwExceptionForError(Response response) throws IntegrationException {
        this.blackDuckHttpClient.throwExceptionForError(response);
    }

    @Override
    public HttpUrl getBaseUrl() {
        return this.blackDuckHttpClient.getBaseUrl();
    }

    @Override
    public String getUserAgentString() {
        return this.blackDuckHttpClient.getUserAgentString();
    }

    @Override
    public HttpClientBuilder getHttpClientBuilder() {
        return this.blackDuckHttpClient.getHttpClientBuilder();
    }

    @Override
    public int getTimeoutInSeconds() {
        return this.blackDuckHttpClient.getTimeoutInSeconds();
    }

    @Override
    public boolean isAlwaysTrustServerCertificate() {
        return this.blackDuckHttpClient.isAlwaysTrustServerCertificate();
    }

    @Override
    public ProxyInfo getProxyInfo() {
        return this.blackDuckHttpClient.getProxyInfo();
    }

    @Override
    public IntLogger getLogger() {
        return this.blackDuckHttpClient.getLogger();
    }
}

