/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome.google.analytics;

import com.google.gson.Gson;
import com.synopsys.integration.phonehome.request.PhoneHomeRequestBody;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class GoogleAnalyticsRequestTransformer {
    private final List<NameValuePair> parameters = new ArrayList<NameValuePair>();
    private final PhoneHomeRequestBody phoneHomeRequestBody;
    private final String trackingId;
    private final Gson gson;

    public GoogleAnalyticsRequestTransformer(Gson gson, String trackingId, PhoneHomeRequestBody phoneHomeRequestBody) {
        this.gson = gson;
        this.phoneHomeRequestBody = phoneHomeRequestBody;
        this.trackingId = trackingId;
    }

    public List<NameValuePair> getParameters() {
        this.addParameter("v", "1");
        this.addParameter("t", "pageview");
        String clientId = this.generateClientId(this.phoneHomeRequestBody.getCustomerId(), this.phoneHomeRequestBody.getHostName());
        this.addParameter("cid", clientId);
        this.addParameter("tid", this.trackingId);
        this.addParameter("dp", "phone-home");
        this.addParameter("cd1", this.phoneHomeRequestBody.getCustomerId());
        this.addParameter("cd7", this.phoneHomeRequestBody.getHostName());
        this.addParameter("cd2", this.phoneHomeRequestBody.getArtifactId());
        this.addParameter("cd3", this.phoneHomeRequestBody.getArtifactVersion());
        this.addParameter("cd4", this.phoneHomeRequestBody.getProductName());
        this.addParameter("cd5", this.phoneHomeRequestBody.getProductVersion());
        this.addParameter("cd6", this.gson.toJson(this.phoneHomeRequestBody.getMetaData()));
        return this.parameters;
    }

    private void addParameter(String key, String value) {
        BasicNameValuePair parameter = new BasicNameValuePair(key, value);
        this.parameters.add((NameValuePair)parameter);
    }

    private String generateClientId(String customerId, String hostName) {
        String clientId = !"<unknown>".equals(customerId) ? customerId : (!"<unknown>".equals(hostName) ? hostName : "<unknown>");
        byte[] bytesFromString = clientId.getBytes();
        return UUID.nameUUIDFromBytes(bytesFromString).toString();
    }
}

