/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.enumeration.PolicyRuleCategoryType;
import com.synopsys.integration.blackduck.api.enumeration.PolicyRuleConditionType;
import com.synopsys.integration.blackduck.api.generated.component.PolicyRuleExpressionExpressionsView;
import com.synopsys.integration.blackduck.api.generated.view.PolicyRuleView;
import java.util.Collections;
import java.util.List;

public class PolicyRuleModel {
    private final PolicyRuleView rule;

    public PolicyRuleModel(PolicyRuleView rule) {
        this.rule = rule;
    }

    public boolean hasExpressions() {
        return this.rule != null && this.rule.getExpression() != null && this.rule.getExpression().getExpressions() != null && !this.rule.getExpression().getExpressions().isEmpty();
    }

    public List<PolicyRuleExpressionExpressionsView> getExpressionList() {
        if (this.hasExpressions()) {
            return this.rule.getExpression().getExpressions();
        }
        return Collections.emptyList();
    }

    public boolean hasOnlyProjectLevelConditions() {
        boolean hasNonProjectLevelCondition = false;
        for (PolicyRuleExpressionExpressionsView expression : this.getExpressionList()) {
            PolicyRuleConditionType condition = PolicyRuleConditionType.valueOf(expression.getName());
            if (PolicyRuleConditionType.UNKNOWN_RULE_CONDTION == condition || PolicyRuleCategoryType.COMPONENT != condition.getPolicyRuleCategory()) continue;
            hasNonProjectLevelCondition = true;
        }
        return !hasNonProjectLevelCondition;
    }
}

