/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation;

import com.synopsys.integration.blackduck.api.generated.view.UserView;
import com.synopsys.integration.blackduck.codelocation.CodeLocationWaitResult;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.CodeLocationWaitJobTask;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.dataservice.NotificationService;
import com.synopsys.integration.blackduck.service.dataservice.ProjectService;
import com.synopsys.integration.blackduck.service.model.NotificationTaskRange;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.util.NameVersion;
import com.synopsys.integration.wait.WaitJob;
import com.synopsys.integration.wait.WaitJobTask;
import java.util.Set;

public class CodeLocationWaiter {
    private final IntLogger logger;
    private final BlackDuckApiClient blackDuckApiClient;
    private final ProjectService projectService;
    private final NotificationService notificationService;

    public CodeLocationWaiter(IntLogger logger, BlackDuckApiClient blackDuckApiClient, ProjectService projectService, NotificationService notificationService) {
        this.logger = logger;
        this.blackDuckApiClient = blackDuckApiClient;
        this.projectService = projectService;
        this.notificationService = notificationService;
    }

    public CodeLocationWaitResult checkCodeLocationsAddedToBom(UserView userView, NotificationTaskRange notificationTaskRange, NameVersion projectAndVersion, Set<String> codeLocationNames, int expectedNotificationCount, long timeoutInSeconds, int waitIntervalInSeconds) throws IntegrationException, InterruptedException {
        CodeLocationWaitJobTask codeLocationWaitJobTask = new CodeLocationWaitJobTask(this.logger, this.blackDuckApiClient, this.projectService, this.notificationService, userView, notificationTaskRange, projectAndVersion, codeLocationNames, expectedNotificationCount);
        boolean allCompleted = codeLocationWaitJobTask.isComplete();
        if ((long)waitIntervalInSeconds > timeoutInSeconds) {
            waitIntervalInSeconds = (int)timeoutInSeconds;
        }
        if (!allCompleted) {
            WaitJob waitJob = WaitJob.create(this.logger, timeoutInSeconds, notificationTaskRange.getTaskStartTime(), waitIntervalInSeconds, (WaitJobTask)codeLocationWaitJobTask);
            allCompleted = waitJob.waitFor();
        }
        if (!allCompleted) {
            return CodeLocationWaitResult.PARTIAL(codeLocationWaitJobTask.getFoundCodeLocationNames(), String.format("It was not possible to verify the code locations were added to the BOM within the timeout (%ds) provided.", timeoutInSeconds));
        }
        this.logger.info("All code locations have been added to the BOM.");
        return CodeLocationWaitResult.COMPLETE(codeLocationWaitJobTask.getFoundCodeLocationNames());
    }
}

