/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.synopsys.integration.blackduck.api.generated.discovery.BlackDuckMediaTypeDiscovery;
import com.synopsys.integration.blackduck.configuration.BlackDuckServerConfigBuilder;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.http.client.ApiTokenBlackDuckHttpClient;
import com.synopsys.integration.blackduck.http.client.BlackDuckHttpClient;
import com.synopsys.integration.blackduck.http.client.CookieHeaderParser;
import com.synopsys.integration.blackduck.http.client.CredentialsBlackDuckHttpClient;
import com.synopsys.integration.blackduck.http.client.cache.CachingHttpClient;
import com.synopsys.integration.blackduck.service.BlackDuckServicesFactory;
import com.synopsys.integration.builder.Buildable;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.SilentIntLogger;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.client.ConnectionResult;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.response.ErrorResponse;
import com.synopsys.integration.rest.response.Response;
import com.synopsys.integration.rest.support.AuthenticationSupport;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.NameVersion;
import com.synopsys.integration.util.Stringable;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

public class BlackDuckServerConfig
extends Stringable
implements Buildable {
    private final HttpUrl blackDuckUrl;
    private final NameVersion solutionDetails;
    private final int timeoutSeconds;
    private final Credentials credentials;
    private final String apiToken;
    private final ProxyInfo proxyInfo;
    private final boolean alwaysTrustServerCertificate;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final Gson gson;
    private final ObjectMapper objectMapper;
    private final AuthenticationSupport authenticationSupport;
    private final BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery;
    private final CookieHeaderParser cookieHeaderParser;
    private final ExecutorService executorService;
    private final BlackDuckRequestFactory blackDuckRequestFactory;

    public static BlackDuckServerConfigBuilder newBuilder() {
        return new BlackDuckServerConfigBuilder();
    }

    BlackDuckServerConfig(HttpUrl url, NameVersion solutionDetails, int timeoutSeconds, Credentials credentials, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate, IntEnvironmentVariables intEnvironmentVariables, Gson gson, ObjectMapper objectMapper, AuthenticationSupport authenticationSupport, BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery, CookieHeaderParser cookieHeaderParser, ExecutorService executorService, BlackDuckRequestFactory blackDuckRequestFactory) {
        this(url, solutionDetails, timeoutSeconds, proxyInfo, alwaysTrustServerCertificate, intEnvironmentVariables, gson, objectMapper, authenticationSupport, blackDuckMediaTypeDiscovery, cookieHeaderParser, executorService, credentials, null, blackDuckRequestFactory);
    }

    BlackDuckServerConfig(HttpUrl url, NameVersion solutionDetails, int timeoutSeconds, String apiToken, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate, IntEnvironmentVariables intEnvironmentVariables, Gson gson, ObjectMapper objectMapper, AuthenticationSupport authenticationSupport, BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery, ExecutorService executorService, BlackDuckRequestFactory blackDuckRequestFactory) {
        this(url, solutionDetails, timeoutSeconds, proxyInfo, alwaysTrustServerCertificate, intEnvironmentVariables, gson, objectMapper, authenticationSupport, blackDuckMediaTypeDiscovery, null, executorService, null, apiToken, blackDuckRequestFactory);
    }

    private BlackDuckServerConfig(HttpUrl url, NameVersion solutionDetails, int timeoutSeconds, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate, IntEnvironmentVariables intEnvironmentVariables, Gson gson, ObjectMapper objectMapper, AuthenticationSupport authenticationSupport, BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery, CookieHeaderParser cookieHeaderParser, ExecutorService executorService, Credentials credentials, String apiToken, BlackDuckRequestFactory blackDuckRequestFactory) {
        this.blackDuckUrl = url;
        this.solutionDetails = solutionDetails;
        this.credentials = credentials;
        this.apiToken = apiToken;
        this.timeoutSeconds = timeoutSeconds;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.gson = gson;
        this.objectMapper = objectMapper;
        this.authenticationSupport = authenticationSupport;
        this.blackDuckMediaTypeDiscovery = blackDuckMediaTypeDiscovery;
        this.cookieHeaderParser = cookieHeaderParser;
        this.executorService = executorService;
        this.blackDuckRequestFactory = blackDuckRequestFactory;
    }

    public boolean shouldUseProxyForBlackDuck() {
        return this.proxyInfo != null && this.proxyInfo.shouldUseProxy();
    }

    public void print(IntLogger logger) {
        if (this.getBlackDuckUrl() != null) {
            logger.alwaysLog("--> Black Duck Server Url: " + this.getBlackDuckUrl());
        }
        if (this.getSolutionDetails() != null) {
            logger.alwaysLog("--> Solution Name: " + this.getSolutionDetails().getName());
            logger.alwaysLog("--> Solution Version: " + this.getSolutionDetails().getVersion());
        }
        if (this.getCredentials().isPresent() && this.getCredentials().get().getUsername().isPresent()) {
            logger.alwaysLog("--> Black Duck User: " + this.getCredentials().get().getUsername().get());
        }
        if (StringUtils.isNotBlank((CharSequence)this.apiToken)) {
            logger.alwaysLog("--> Black Duck API Token Used");
        }
        if (this.alwaysTrustServerCertificate) {
            logger.alwaysLog("--> Trust Black Duck certificate: " + this.isAlwaysTrustServerCertificate());
        }
        if (this.proxyInfo != null && this.proxyInfo.shouldUseProxy()) {
            if (StringUtils.isNotBlank((CharSequence)this.proxyInfo.getHost().orElse(null))) {
                logger.alwaysLog("--> Proxy Host: " + this.proxyInfo.getHost());
            }
            if (this.proxyInfo.getPort() > 0) {
                logger.alwaysLog("--> Proxy Port: " + this.proxyInfo.getPort());
            }
            if (StringUtils.isNotBlank((CharSequence)this.proxyInfo.getUsername().orElse(null))) {
                logger.alwaysLog("--> Proxy Username: " + this.proxyInfo.getUsername());
            }
        }
    }

    public boolean canConnect() {
        return this.canConnect(new SilentIntLogger());
    }

    public boolean canConnect(IntLogger logger) {
        ConnectionResult connectionResult = this.attemptConnection(logger);
        return connectionResult.isSuccess();
    }

    public ConnectionResult attemptConnection(IntLogger logger) {
        String errorMessage = null;
        Exception exception = null;
        int httpStatusCode = 0;
        try {
            BlackDuckHttpClient blackDuckHttpClient = this.createBlackDuckHttpClient(logger);
            try (Response response = blackDuckHttpClient.attemptAuthentication();){
                httpStatusCode = response.getStatusCode();
                if (response.isStatusCodeError()) {
                    String httpResponseContent = response.getContentString();
                    Optional<ErrorResponse> errorResponse = blackDuckHttpClient.extractErrorResponse(httpResponseContent);
                    errorMessage = errorResponse.isPresent() ? errorResponse.get().getErrorMessage() : "The connection was not successful for an unknown reason. If an api token is being used, it could be incorrect.";
                }
            }
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            exception = e;
        }
        if (null != errorMessage) {
            logger.error(errorMessage);
            return ConnectionResult.FAILURE(httpStatusCode, errorMessage, exception);
        }
        logger.info("A successful connection was made.");
        return ConnectionResult.SUCCESS(httpStatusCode);
    }

    public BlackDuckServicesFactory createBlackDuckServicesFactory(IntLogger logger) {
        BlackDuckHttpClient blackDuckHttpClient = this.createBlackDuckHttpClient(logger);
        return this.createBlackDuckServicesFactory(blackDuckHttpClient, logger);
    }

    public BlackDuckServicesFactory createCachedBlackDuckServicesFactory(IntLogger logger) {
        CachingHttpClient blackDuckHttpClient = this.createCacheHttpClient(logger);
        return this.createBlackDuckServicesFactory(blackDuckHttpClient, logger);
    }

    public BlackDuckServicesFactory createBlackDuckServicesFactory(BlackDuckHttpClient blackDuckHttpClient, IntLogger logger) {
        return new BlackDuckServicesFactory(this.intEnvironmentVariables, this.gson, this.objectMapper, this.executorService, blackDuckHttpClient, logger, this.blackDuckRequestFactory);
    }

    public BlackDuckHttpClient createBlackDuckHttpClient(IntLogger logger) {
        if (this.usingApiToken()) {
            return this.createApiTokenBlackDuckHttpClient(logger);
        }
        return this.createCredentialsBlackDuckHttpClient(logger);
    }

    public CachingHttpClient createCacheHttpClient(IntLogger logger) {
        BlackDuckHttpClient blackDuckHttpClient = this.createBlackDuckHttpClient(logger);
        return new CachingHttpClient(blackDuckHttpClient);
    }

    public CredentialsBlackDuckHttpClient createCredentialsBlackDuckHttpClient(IntLogger logger) {
        return new CredentialsBlackDuckHttpClient(logger, this.getTimeout(), this.isAlwaysTrustServerCertificate(), this.getProxyInfo(), this.getBlackDuckUrl(), this.getSolutionDetails(), this.authenticationSupport, this.getCredentials().orElse(null), this.blackDuckMediaTypeDiscovery, this.cookieHeaderParser);
    }

    public ApiTokenBlackDuckHttpClient createApiTokenBlackDuckHttpClient(IntLogger logger) {
        return new ApiTokenBlackDuckHttpClient(logger, this.getTimeout(), this.isAlwaysTrustServerCertificate(), this.getProxyInfo(), this.getBlackDuckUrl(), this.getSolutionDetails(), this.gson, this.authenticationSupport, this.getApiToken().orElse(null), this.blackDuckMediaTypeDiscovery);
    }

    public boolean usingApiToken() {
        return StringUtils.isNotBlank((CharSequence)this.apiToken);
    }

    public HttpUrl getBlackDuckUrl() {
        return this.blackDuckUrl;
    }

    public NameVersion getSolutionDetails() {
        return this.solutionDetails;
    }

    public Optional<Credentials> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    public Optional<String> getApiToken() {
        return Optional.ofNullable(this.apiToken);
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public int getTimeout() {
        return this.timeoutSeconds;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }
}

