/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http.client.cache;

import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class CacheableResponse
implements Response {
    private final Request request;
    private final Response response;
    private final LRUMap<Request, Response> cache;
    private String stringResponse;

    public CacheableResponse(Request request, Response response, LRUMap<Request, Response> cache) {
        this.request = request;
        this.response = response;
        this.cache = cache;
    }

    @Override
    public HttpUriRequest getRequest() {
        return this.response.getRequest();
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    @Override
    public boolean isStatusCodeSuccess() {
        return this.response.isStatusCodeSuccess();
    }

    @Override
    public boolean isStatusCodeError() {
        return this.response.isStatusCodeError();
    }

    @Override
    public String getStatusMessage() {
        return this.response.getStatusMessage();
    }

    @Override
    public InputStream getContent() throws IntegrationException {
        return this.response.getContent();
    }

    @Override
    public String getContentString() throws IntegrationException {
        if (null != this.stringResponse) {
            return this.stringResponse;
        }
        this.stringResponse = this.response.getContentString();
        this.cache.put((Object)this.request, (Object)this);
        return this.stringResponse;
    }

    @Override
    public String getContentString(Charset encoding) throws IntegrationException {
        if (null != this.stringResponse) {
            return this.stringResponse;
        }
        this.stringResponse = this.response.getContentString(encoding);
        this.cache.put((Object)this.request, (Object)this);
        return this.stringResponse;
    }

    @Override
    public Long getContentLength() {
        return this.response.getContentLength();
    }

    @Override
    public String getContentEncoding() {
        return this.response.getContentEncoding();
    }

    @Override
    public String getContentType() {
        return this.response.getContentType();
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.response.getHeaders();
    }

    @Override
    public String getHeaderValue(String name) {
        return this.response.getHeaderValue(name);
    }

    @Override
    public CloseableHttpResponse getActualResponse() {
        return this.response.getActualResponse();
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }

    @Override
    public long getLastModified() throws IntegrationException {
        return this.response.getLastModified();
    }

    @Override
    public void throwExceptionForError() throws IntegrationRestException {
        this.response.throwExceptionForError();
    }
}

