/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio.graph;

import com.synopsys.integration.bdio.BdioNodeFactory;
import com.synopsys.integration.bdio.BdioPropertyHelper;
import com.synopsys.integration.bdio.graph.DependencyGraph;
import com.synopsys.integration.bdio.model.BdioComponent;
import com.synopsys.integration.bdio.model.BdioExternalIdentifier;
import com.synopsys.integration.bdio.model.BdioId;
import com.synopsys.integration.bdio.model.BdioNode;
import com.synopsys.integration.bdio.model.dependency.Dependency;
import com.synopsys.integration.bdio.model.externalid.ExternalId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyGraphTransformer {
    private final BdioPropertyHelper bdioPropertyHelper;
    private final BdioNodeFactory bdioNodeFactory;

    public DependencyGraphTransformer(BdioPropertyHelper bdioPropertyHelper, BdioNodeFactory bdioNodeFactory) {
        this.bdioPropertyHelper = bdioPropertyHelper;
        this.bdioNodeFactory = bdioNodeFactory;
    }

    public List<BdioComponent> transformDependencyGraph(DependencyGraph graph, BdioNode currentNode, Set<Dependency> dependencies, Map<ExternalId, BdioNode> existingComponents) {
        ArrayList<BdioComponent> addedComponents = new ArrayList<BdioComponent>();
        for (Dependency dependency : dependencies) {
            if (!existingComponents.containsKey(dependency.getExternalId())) {
                BdioComponent addedNode = this.componentFromDependency(dependency);
                addedComponents.add(addedNode);
                existingComponents.put(dependency.getExternalId(), addedNode);
                List<BdioComponent> addedChildren = this.transformDependencyGraph(graph, addedNode, graph.getChildrenForParent(dependency), existingComponents);
                addedComponents.addAll(addedChildren);
            }
            this.bdioPropertyHelper.addRelationship(currentNode, existingComponents.get(dependency.getExternalId()));
        }
        return addedComponents;
    }

    private BdioComponent componentFromDependency(Dependency dependency) {
        String componentName = dependency.getName();
        String componentVersion = dependency.getVersion();
        BdioId componentId = dependency.getExternalId().createBdioId();
        BdioExternalIdentifier componentExternalIdentifier = this.bdioPropertyHelper.createExternalIdentifier(dependency.getExternalId());
        BdioComponent component = this.bdioNodeFactory.createComponent(componentName, componentVersion, componentId, componentExternalIdentifier);
        return component;
    }
}

