/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.bdio2;

import com.blackducksoftware.bdio2.BdioMetadata;
import com.blackducksoftware.bdio2.BdioObject;
import com.blackducksoftware.bdio2.model.Component;
import com.blackducksoftware.bdio2.model.Project;
import com.blackducksoftware.common.value.Product;
import com.blackducksoftware.common.value.ProductList;
import com.synopsys.integration.bdio.graph.DependencyGraph;
import com.synopsys.integration.bdio.model.dependency.Dependency;
import com.synopsys.integration.bdio.model.externalid.ExternalId;
import com.synopsys.integration.blackduck.bdio2.Bdio2Document;
import com.synopsys.integration.blackduck.bdio2.LegacyUtilitiesClone;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class Bdio2Factory {
    public Bdio2Document createBdio2Document(BdioMetadata bdioMetadata, Project project, DependencyGraph dependencyGraph) {
        List<Component> components = this.createAndLinkComponents(dependencyGraph, project);
        return new Bdio2Document(bdioMetadata, project, components);
    }

    public BdioMetadata createBdioMetadata(String codeLocationName, ZonedDateTime creationDateTime, ProductList.Builder productListBuilder) {
        return new BdioMetadata().id(LegacyUtilitiesClone.toNameUri(codeLocationName)).name(codeLocationName).creationDateTime(creationDateTime).publisher(productListBuilder.addProduct(Product.java()).addProduct(Product.os()).build());
    }

    public Project createProject(ExternalId projectExternalId, String projectName, String projectVersionName) {
        return new Project(projectExternalId.createBdioId().toString()).identifier(projectExternalId.createExternalId()).name(projectName).version(projectVersionName);
    }

    public List<Component> createAndLinkComponents(DependencyGraph dependencyGraph, Project project) {
        return this.createAndLinkComponentsFromGraph(dependencyGraph, arg_0 -> ((Project)project).dependency(arg_0), dependencyGraph.getRootDependencies(), new HashMap<ExternalId, Component>());
    }

    private List<Component> createAndLinkComponentsFromGraph(DependencyGraph dependencyGraph, DependencyFunction dependencyFunction, Set<Dependency> dependencies, Map<ExternalId, Component> existingComponents) {
        ArrayList<Component> addedComponents = new ArrayList<Component>();
        for (Dependency dependency : dependencies) {
            Component component = this.componentFromDependency(dependency);
            dependencyFunction.dependency(new com.blackducksoftware.bdio2.model.Dependency().dependsOn((Object)component));
            if (existingComponents.containsKey(dependency.getExternalId())) continue;
            addedComponents.add(component);
            existingComponents.put(dependency.getExternalId(), component);
            List<Component> children = this.createAndLinkComponentsFromGraph(dependencyGraph, arg_0 -> ((Component)component).dependency(arg_0), dependencyGraph.getChildrenForParent(dependency), existingComponents);
            addedComponents.addAll(children);
        }
        return addedComponents;
    }

    private Component componentFromDependency(Dependency dependency) {
        return new Component(dependency.getExternalId().createBdioId().toString()).name(dependency.getName()).version(dependency.getVersion()).identifier(dependency.getExternalId().createExternalId()).namespace(dependency.getExternalId().getForge().getName());
    }

    @FunctionalInterface
    private static interface DependencyFunction {
        public BdioObject dependency(@Nullable com.blackducksoftware.bdio2.model.Dependency var1);
    }
}

