/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.signaturescanner.command;

import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanPaths;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanPathsUtility;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.http.client.SignatureScannerClient;
import com.synopsys.integration.blackduck.keystore.KeyStoreHelper;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.Response;
import com.synopsys.integration.util.CleanupZipExpander;
import com.synopsys.integration.util.OperatingSystemType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveException;

public class ScannerZipInstaller {
    public static final String DEFAULT_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX = "download/scan.cli.zip";
    public static final String WINDOWS_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX = "download/scan.cli-windows.zip";
    public static final String MAC_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX = "download/scan.cli-macosx.zip";
    public static final String BLACK_DUCK_SIGNATURE_SCANNER_INSTALL_DIRECTORY = "Black_Duck_Scan_Installation";
    public static final String VERSION_FILENAME = "blackDuckVersion.txt";
    private final IntLogger logger;
    private final SignatureScannerClient signatureScannerClient;
    private final CleanupZipExpander cleanupZipExpander;
    private final ScanPathsUtility scanPathsUtility;
    private final KeyStoreHelper keyStoreHelper;
    private final HttpUrl blackDuckServerUrl;
    private final OperatingSystemType operatingSystemType;

    public ScannerZipInstaller(IntLogger logger, SignatureScannerClient signatureScannerClient, CleanupZipExpander cleanupZipExpander, ScanPathsUtility scanPathsUtility, KeyStoreHelper keyStoreHelper, HttpUrl blackDuckServerUrl, OperatingSystemType operatingSystemType) {
        if (null == blackDuckServerUrl) {
            throw new IllegalArgumentException("A Black Duck server url must be provided.");
        }
        this.logger = logger;
        this.signatureScannerClient = signatureScannerClient;
        this.cleanupZipExpander = cleanupZipExpander;
        this.scanPathsUtility = scanPathsUtility;
        this.keyStoreHelper = keyStoreHelper;
        this.blackDuckServerUrl = blackDuckServerUrl;
        this.operatingSystemType = operatingSystemType;
    }

    public void installOrUpdateScanner(File installDirectory) throws BlackDuckIntegrationException {
        File scannerExpansionDirectory = new File(installDirectory, BLACK_DUCK_SIGNATURE_SCANNER_INSTALL_DIRECTORY);
        scannerExpansionDirectory.mkdirs();
        File versionFile = null;
        try {
            versionFile = this.retrieveVersionFile(scannerExpansionDirectory);
        }
        catch (IOException e) {
            throw new BlackDuckIntegrationException("Trying to install the scanner but could not create the version file: " + e.getMessage(), e);
        }
        HttpUrl downloadUrl = this.getDownloadUrl();
        try {
            this.downloadIfModified(scannerExpansionDirectory, versionFile, downloadUrl);
        }
        catch (Exception e) {
            throw new BlackDuckIntegrationException("The Black Duck Signature Scanner could not be downloaded successfully: " + e.getMessage(), e);
        }
        this.logger.info("The Black Duck Signature Scanner downloaded/found successfully: " + installDirectory.getAbsolutePath());
    }

    private File retrieveVersionFile(File scannerExpansionDirectory) throws IOException {
        File versionFile = new File(scannerExpansionDirectory, VERSION_FILENAME);
        if (!versionFile.exists()) {
            this.logger.info("The version file has not been created yet so creating it now.");
            versionFile.createNewFile();
            versionFile.setLastModified(0L);
        }
        return versionFile;
    }

    private HttpUrl getDownloadUrl() throws BlackDuckIntegrationException {
        StringBuilder url = new StringBuilder(this.blackDuckServerUrl.string());
        if (!this.blackDuckServerUrl.string().endsWith("/")) {
            url.append("/");
        }
        if (OperatingSystemType.MAC == this.operatingSystemType) {
            url.append(MAC_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX);
        } else if (OperatingSystemType.WINDOWS == this.operatingSystemType) {
            url.append(WINDOWS_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX);
        } else {
            url.append(DEFAULT_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX);
        }
        try {
            return new HttpUrl(url.toString());
        }
        catch (IntegrationException e) {
            throw new BlackDuckIntegrationException(String.format("The Black Duck Signature Scanner url (%s) is not valid.", url.toString()));
        }
    }

    private void downloadIfModified(File scannerExpansionDirectory, File versionFile, HttpUrl downloadUrl) throws IOException, IntegrationException, ArchiveException {
        long lastTimeDownloaded = versionFile.lastModified();
        this.logger.debug(String.format("last time downloaded: %d", lastTimeDownloaded));
        Request downloadRequest = (Request)new Request.Builder(downloadUrl).build();
        Optional<Response> optionalResponse = this.signatureScannerClient.executeGetRequestIfModifiedSince(downloadRequest, lastTimeDownloaded);
        if (!optionalResponse.isPresent()) {
            this.logger.debug("The Black Duck Signature Scanner has not been modified since it was last downloaded - skipping download.");
            return;
        }
        try (Response response = optionalResponse.get();){
            this.logger.info("Downloading the Black Duck Signature Scanner.");
            try (InputStream responseStream = response.getContent();){
                this.logger.info(String.format("If your Black Duck server has changed, the contents of %s may change which could involve deleting files - please do not place items in the expansion directory as this directory is assumed to be under blackduck-common control.", scannerExpansionDirectory.getAbsolutePath()));
                this.cleanupZipExpander.expand(responseStream, scannerExpansionDirectory);
            }
            long lastModifiedOnServer = response.getLastModified();
            versionFile.setLastModified(lastModifiedOnServer);
            ScanPaths scanPaths = this.scanPathsUtility.determineSignatureScannerPaths(scannerExpansionDirectory.getParentFile());
            File javaExecutable = new File(scanPaths.getPathToJavaExecutable());
            File oneJar = new File(scanPaths.getPathToOneJar());
            File scanExecutable = new File(scanPaths.getPathToScanExecutable());
            javaExecutable.setExecutable(true);
            oneJar.setExecutable(true);
            scanExecutable.setExecutable(true);
            Certificate serverCertificate = this.signatureScannerClient.getServerCertificate();
            this.keyStoreHelper.updateKeyStoreWithServerCertificate(downloadUrl.url().getHost(), serverCertificate, scanPaths.getPathToCacerts());
            this.logger.info("Black Duck Signature Scanner downloaded successfully.");
        }
    }
}

