/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.synopsys.integration.blackduck.api.generated.discovery.BlackDuckMediaTypeDiscovery;
import com.synopsys.integration.blackduck.configuration.BlackDuckServerConfig;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.http.client.CookieHeaderParser;
import com.synopsys.integration.blackduck.service.BlackDuckServicesFactory;
import com.synopsys.integration.builder.BuilderProperties;
import com.synopsys.integration.builder.BuilderPropertyKey;
import com.synopsys.integration.builder.BuilderStatus;
import com.synopsys.integration.builder.IntegrationBuilder;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.LogLevel;
import com.synopsys.integration.log.PrintStreamIntLogger;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.credentials.CredentialsBuilder;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.proxy.ProxyInfoBuilder;
import com.synopsys.integration.rest.support.AuthenticationSupport;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.NameVersion;
import com.synopsys.integration.util.NoThreadExecutorService;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BlackDuckServerConfigBuilder
extends IntegrationBuilder<BlackDuckServerConfig> {
    public static final BuilderPropertyKey URL_KEY = new BuilderPropertyKey("BLACKDUCK_URL");
    public static final BuilderPropertyKey SOLUTION_NAME_KEY = new BuilderPropertyKey("SOLUTION_NAME_KEY");
    public static final BuilderPropertyKey SOLUTION_VERSION_KEY = new BuilderPropertyKey("SOLUTION_VERSION_KEY");
    public static final BuilderPropertyKey USERNAME_KEY = new BuilderPropertyKey("BLACKDUCK_USERNAME");
    public static final BuilderPropertyKey PASSWORD_KEY = new BuilderPropertyKey("BLACKDUCK_PASSWORD");
    public static final BuilderPropertyKey API_TOKEN_KEY = new BuilderPropertyKey("BLACKDUCK_API_TOKEN");
    public static final BuilderPropertyKey TIMEOUT_KEY = new BuilderPropertyKey("BLACKDUCK_TIMEOUT");
    public static final BuilderPropertyKey PROXY_HOST_KEY = new BuilderPropertyKey("BLACKDUCK_PROXY_HOST");
    public static final BuilderPropertyKey PROXY_PORT_KEY = new BuilderPropertyKey("BLACKDUCK_PROXY_PORT");
    public static final BuilderPropertyKey PROXY_USERNAME_KEY = new BuilderPropertyKey("BLACKDUCK_PROXY_USERNAME");
    public static final BuilderPropertyKey PROXY_PASSWORD_KEY = new BuilderPropertyKey("BLACKDUCK_PROXY_PASSWORD");
    public static final BuilderPropertyKey PROXY_NTLM_DOMAIN_KEY = new BuilderPropertyKey("BLACKDUCK_PROXY_NTLM_DOMAIN");
    public static final BuilderPropertyKey PROXY_NTLM_WORKSTATION_KEY = new BuilderPropertyKey("BLACKDUCK_PROXY_NTLM_WORKSTATION");
    public static final BuilderPropertyKey TRUST_CERT_KEY = new BuilderPropertyKey("BLACKDUCK_TRUST_CERT");
    public static int DEFAULT_TIMEOUT_SECONDS = 120;
    private final BuilderProperties builderProperties;
    private IntLogger logger = new PrintStreamIntLogger(System.out, LogLevel.INFO);
    private IntEnvironmentVariables intEnvironmentVariables = IntEnvironmentVariables.includeSystemEnv();
    private Gson gson = BlackDuckServicesFactory.createDefaultGson();
    private ObjectMapper objectMapper = BlackDuckServicesFactory.createDefaultObjectMapper();
    private AuthenticationSupport authenticationSupport = new AuthenticationSupport();
    private BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery = new BlackDuckMediaTypeDiscovery();
    private CookieHeaderParser cookieHeaderParser = new CookieHeaderParser();
    private ExecutorService executorService = new NoThreadExecutorService();
    private BlackDuckRequestFactory blackDuckRequestFactory = BlackDuckServicesFactory.createDefaultRequestFactory();

    public BlackDuckServerConfigBuilder() {
        HashSet<BuilderPropertyKey> propertyKeys = new HashSet<BuilderPropertyKey>();
        propertyKeys.add(URL_KEY);
        propertyKeys.add(SOLUTION_NAME_KEY);
        propertyKeys.add(SOLUTION_VERSION_KEY);
        propertyKeys.add(USERNAME_KEY);
        propertyKeys.add(PASSWORD_KEY);
        propertyKeys.add(API_TOKEN_KEY);
        propertyKeys.add(TIMEOUT_KEY);
        propertyKeys.add(PROXY_HOST_KEY);
        propertyKeys.add(PROXY_PORT_KEY);
        propertyKeys.add(PROXY_USERNAME_KEY);
        propertyKeys.add(PROXY_PASSWORD_KEY);
        propertyKeys.add(PROXY_NTLM_DOMAIN_KEY);
        propertyKeys.add(PROXY_NTLM_WORKSTATION_KEY);
        propertyKeys.add(TRUST_CERT_KEY);
        this.builderProperties = new BuilderProperties(propertyKeys);
        this.builderProperties.set(TIMEOUT_KEY, Integer.toString(DEFAULT_TIMEOUT_SECONDS));
    }

    @Override
    public BlackDuckServerConfig buildWithoutValidation() {
        HttpUrl blackDuckUrl = null;
        try {
            blackDuckUrl = new HttpUrl(this.getUrl());
        }
        catch (IntegrationException integrationException) {
            // empty catch block
        }
        NameVersion solutionDetails = this.getSolutionDetails();
        ProxyInfo proxyInfo = this.getProxyInfo();
        if (StringUtils.isNotBlank((CharSequence)this.getApiToken())) {
            return new BlackDuckServerConfig(blackDuckUrl, solutionDetails, this.getTimemoutInSeconds(), this.getApiToken(), proxyInfo, this.isTrustCert(), this.intEnvironmentVariables, this.gson, this.objectMapper, this.authenticationSupport, this.blackDuckMediaTypeDiscovery, this.executorService, this.blackDuckRequestFactory);
        }
        String username = this.getUsername();
        String password = this.getPassword();
        CredentialsBuilder credentialsBuilder = Credentials.newBuilder();
        credentialsBuilder.setUsernameAndPassword(username, password);
        Credentials credentials = (Credentials)credentialsBuilder.build();
        return new BlackDuckServerConfig(blackDuckUrl, solutionDetails, this.getTimemoutInSeconds(), credentials, proxyInfo, this.isTrustCert(), this.intEnvironmentVariables, this.gson, this.objectMapper, this.authenticationSupport, this.blackDuckMediaTypeDiscovery, this.cookieHeaderParser, this.executorService, this.blackDuckRequestFactory);
    }

    @Override
    protected void validate(BuilderStatus builderStatus) {
        this.validateBlackDuckUrl(builderStatus);
        if (StringUtils.isBlank((CharSequence)this.getApiToken())) {
            this.validateBlackDuckCredentials(builderStatus);
        }
        this.validateProxyDetails(builderStatus);
        if (this.getTimemoutInSeconds() <= 0) {
            builderStatus.addErrorMessage("The timeout must be greater than zero.");
        }
    }

    private void validateProxyDetails(BuilderStatus builderStatus) {
        CredentialsBuilder proxyCredentialsBuilder = new CredentialsBuilder();
        proxyCredentialsBuilder.setUsername(this.getProxyUsername());
        proxyCredentialsBuilder.setPassword(this.getProxyPassword());
        BuilderStatus proxyCredentialsBuilderStatus = proxyCredentialsBuilder.validateAndGetBuilderStatus();
        if (!proxyCredentialsBuilderStatus.isValid()) {
            builderStatus.addErrorMessage("The proxy credentials were not valid.");
            builderStatus.addAllErrorMessages(proxyCredentialsBuilderStatus.getErrorMessages());
        } else {
            Credentials proxyCredentials = (Credentials)proxyCredentialsBuilder.build();
            ProxyInfoBuilder proxyInfoBuilder = new ProxyInfoBuilder();
            proxyInfoBuilder.setCredentials(proxyCredentials);
            proxyInfoBuilder.setHost(this.getProxyHost());
            proxyInfoBuilder.setPort(this.getProxyPort());
            proxyInfoBuilder.setNtlmDomain(this.getProxyNtlmDomain());
            proxyInfoBuilder.setNtlmWorkstation(this.getProxyNtlmWorkstation());
            BuilderStatus proxyInfoBuilderStatus = proxyInfoBuilder.validateAndGetBuilderStatus();
            if (!proxyInfoBuilderStatus.isValid()) {
                builderStatus.addAllErrorMessages(proxyInfoBuilderStatus.getErrorMessages());
            }
        }
    }

    private void validateBlackDuckCredentials(BuilderStatus builderStatus) {
        CredentialsBuilder credentialsBuilder = new CredentialsBuilder();
        credentialsBuilder.setUsername(this.getUsername());
        credentialsBuilder.setPassword(this.getPassword());
        BuilderStatus credentialsBuilderStatus = credentialsBuilder.validateAndGetBuilderStatus();
        if (!credentialsBuilderStatus.isValid()) {
            builderStatus.addAllErrorMessages(credentialsBuilderStatus.getErrorMessages());
        } else {
            Credentials credentials = (Credentials)credentialsBuilder.build();
            if (credentials.isBlank()) {
                builderStatus.addErrorMessage("Either an API token or a username/password must be specified.");
            }
        }
    }

    private void validateBlackDuckUrl(BuilderStatus builderStatus) {
        if (StringUtils.isBlank((CharSequence)this.getUrl())) {
            builderStatus.addErrorMessage("The Black Duck url must be specified.");
        } else {
            try {
                new HttpUrl(this.getUrl());
            }
            catch (IntegrationException e) {
                builderStatus.addErrorMessage(String.format("The provided Black Duck url (%s) is not a valid URL.", this.getUrl()));
            }
        }
    }

    public Set<BuilderPropertyKey> getKeys() {
        return this.builderProperties.getKeys();
    }

    public Set<String> getPropertyKeys() {
        return this.builderProperties.getPropertyKeys();
    }

    public Set<String> getEnvironmentVariableKeys() {
        return this.builderProperties.getEnvironmentVariableKeys();
    }

    public Map<BuilderPropertyKey, String> getProperties() {
        return this.builderProperties.getProperties();
    }

    public void setProperties(Set<? extends Map.Entry<String, String>> propertyEntries) {
        this.builderProperties.setProperties(propertyEntries);
    }

    public void setProperty(String key, String value) {
        this.builderProperties.setProperty(key, value);
    }

    public ProxyInfo getProxyInfo() {
        String proxyHost = this.getProxyHost();
        if (StringUtils.isBlank((CharSequence)proxyHost)) {
            return ProxyInfo.NO_PROXY_INFO;
        }
        int proxyPort = this.getProxyPort();
        String username = this.getProxyUsername();
        String password = this.getProxyPassword();
        CredentialsBuilder credentialsBuilder = Credentials.newBuilder();
        credentialsBuilder.setUsernameAndPassword(username, password);
        Credentials proxyCredentials = (Credentials)credentialsBuilder.build();
        String proxyNtlmDomain = this.getProxyNtlmDomain();
        String proxyNtlmWorkstation = this.getProxyNtlmWorkstation();
        ProxyInfoBuilder proxyInfoBuilder = ProxyInfo.newBuilder();
        proxyInfoBuilder.setHost(proxyHost);
        proxyInfoBuilder.setPort(proxyPort);
        proxyInfoBuilder.setCredentials(proxyCredentials);
        proxyInfoBuilder.setNtlmDomain(proxyNtlmDomain);
        proxyInfoBuilder.setNtlmWorkstation(proxyNtlmWorkstation);
        return (ProxyInfo)proxyInfoBuilder.build();
    }

    public BlackDuckServerConfigBuilder setProxyInfo(ProxyInfo proxyInfo) {
        this.setProxyHost(proxyInfo.getHost().orElse(null));
        this.setProxyPort(proxyInfo.getPort());
        this.setProxyUsername(proxyInfo.getUsername().orElse(null));
        this.setProxyPassword(proxyInfo.getPassword().orElse(null));
        this.setProxyNtlmDomain(proxyInfo.getNtlmDomain().orElse(null));
        this.setProxyNtlmWorkstation(proxyInfo.getNtlmWorkstation().orElse(null));
        return this;
    }

    public IntLogger getLogger() {
        return this.logger;
    }

    public BlackDuckServerConfigBuilder setLogger(IntLogger logger) {
        if (null != logger) {
            this.logger = logger;
        }
        return this;
    }

    public Optional<ExecutorService> getExecutorService() {
        return Optional.ofNullable(this.executorService);
    }

    public BlackDuckServerConfigBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public AuthenticationSupport getAuthenticationSupport() {
        return this.authenticationSupport;
    }

    public BlackDuckServerConfigBuilder setAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        if (null != authenticationSupport) {
            this.authenticationSupport = authenticationSupport;
        }
        return this;
    }

    public BlackDuckMediaTypeDiscovery getBlackDuckMediaTypeDiscovery() {
        return this.blackDuckMediaTypeDiscovery;
    }

    public BlackDuckServerConfigBuilder setBlackDuckMediaTypeDiscovery(BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery) {
        if (null != blackDuckMediaTypeDiscovery) {
            this.blackDuckMediaTypeDiscovery = blackDuckMediaTypeDiscovery;
        }
        return this;
    }

    public CookieHeaderParser getCookieHeaderParser() {
        return this.cookieHeaderParser;
    }

    public BlackDuckServerConfigBuilder setCookieHeaderParser(CookieHeaderParser cookieHeaderParser) {
        if (null != cookieHeaderParser) {
            this.cookieHeaderParser = cookieHeaderParser;
        }
        return this;
    }

    public Gson getGson() {
        return this.gson;
    }

    public BlackDuckServerConfigBuilder setGson(Gson gson) {
        if (null != gson) {
            this.gson = gson;
        }
        return this;
    }

    public IntEnvironmentVariables getIntEnvironmentVariables() {
        return this.intEnvironmentVariables;
    }

    public BlackDuckServerConfigBuilder setIntEnvironmentVariables(IntEnvironmentVariables intEnvironmentVariables) {
        if (null != intEnvironmentVariables) {
            this.intEnvironmentVariables = intEnvironmentVariables;
        }
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public BlackDuckServerConfigBuilder setObjectMapper(ObjectMapper objectMapper) {
        if (null != objectMapper) {
            this.objectMapper = objectMapper;
        }
        return this;
    }

    public String getUrl() {
        return this.builderProperties.get(URL_KEY);
    }

    public BlackDuckServerConfigBuilder setUrl(String url) {
        this.builderProperties.set(URL_KEY, url);
        return this;
    }

    public BlackDuckServerConfigBuilder setUrl(HttpUrl url) {
        this.builderProperties.set(URL_KEY, url.string());
        return this;
    }

    public NameVersion getSolutionDetails() {
        return new NameVersion(this.builderProperties.get(SOLUTION_NAME_KEY), this.builderProperties.get(SOLUTION_VERSION_KEY));
    }

    public BlackDuckServerConfigBuilder setSolutionDetails(String name, String version) {
        this.builderProperties.set(SOLUTION_NAME_KEY, name);
        this.builderProperties.set(SOLUTION_VERSION_KEY, version);
        return this;
    }

    public BlackDuckServerConfigBuilder setSolutionDetails(NameVersion solutionDetails) {
        this.builderProperties.set(SOLUTION_NAME_KEY, solutionDetails.getName());
        this.builderProperties.set(SOLUTION_VERSION_KEY, solutionDetails.getVersion());
        return this;
    }

    public BlackDuckServerConfigBuilder setCredentials(Credentials credentials) {
        this.builderProperties.set(USERNAME_KEY, credentials.getUsername().orElse(null));
        this.builderProperties.set(PASSWORD_KEY, credentials.getPassword().orElse(null));
        return this;
    }

    public String getUsername() {
        return this.builderProperties.get(USERNAME_KEY);
    }

    public BlackDuckServerConfigBuilder setUsername(String username) {
        this.builderProperties.set(USERNAME_KEY, username);
        return this;
    }

    public String getPassword() {
        return this.builderProperties.get(PASSWORD_KEY);
    }

    public BlackDuckServerConfigBuilder setPassword(String password) {
        this.builderProperties.set(PASSWORD_KEY, password);
        return this;
    }

    public String getApiToken() {
        return this.builderProperties.get(API_TOKEN_KEY);
    }

    public BlackDuckServerConfigBuilder setApiToken(String apiToken) {
        this.builderProperties.set(API_TOKEN_KEY, apiToken);
        return this;
    }

    public int getTimemoutInSeconds() {
        return NumberUtils.toInt((String)this.builderProperties.get(TIMEOUT_KEY), (int)DEFAULT_TIMEOUT_SECONDS);
    }

    public BlackDuckServerConfigBuilder setTimeoutInSeconds(String timeout) {
        this.builderProperties.set(TIMEOUT_KEY, timeout);
        return this;
    }

    public BlackDuckServerConfigBuilder setTimeoutInSeconds(int timeout) {
        this.setTimeoutInSeconds(String.valueOf(timeout));
        return this;
    }

    public String getProxyHost() {
        return this.builderProperties.get(PROXY_HOST_KEY);
    }

    public BlackDuckServerConfigBuilder setProxyHost(String proxyHost) {
        this.builderProperties.set(PROXY_HOST_KEY, proxyHost);
        return this;
    }

    public int getProxyPort() {
        return NumberUtils.toInt((String)this.builderProperties.get(PROXY_PORT_KEY), (int)0);
    }

    public BlackDuckServerConfigBuilder setProxyPort(String proxyPort) {
        this.builderProperties.set(PROXY_PORT_KEY, proxyPort);
        return this;
    }

    public BlackDuckServerConfigBuilder setProxyPort(int proxyPort) {
        this.setProxyPort(String.valueOf(proxyPort));
        return this;
    }

    public String getProxyUsername() {
        return this.builderProperties.get(PROXY_USERNAME_KEY);
    }

    public BlackDuckServerConfigBuilder setProxyUsername(String proxyUsername) {
        this.builderProperties.set(PROXY_USERNAME_KEY, proxyUsername);
        return this;
    }

    public String getProxyPassword() {
        return this.builderProperties.get(PROXY_PASSWORD_KEY);
    }

    public BlackDuckServerConfigBuilder setProxyPassword(String proxyPassword) {
        this.builderProperties.set(PROXY_PASSWORD_KEY, proxyPassword);
        return this;
    }

    public String getProxyNtlmDomain() {
        return this.builderProperties.get(PROXY_NTLM_DOMAIN_KEY);
    }

    public BlackDuckServerConfigBuilder setProxyNtlmDomain(String proxyNtlmDomain) {
        this.builderProperties.set(PROXY_NTLM_DOMAIN_KEY, proxyNtlmDomain);
        return this;
    }

    public String getProxyNtlmWorkstation() {
        return this.builderProperties.get(PROXY_NTLM_WORKSTATION_KEY);
    }

    public BlackDuckServerConfigBuilder setProxyNtlmWorkstation(String proxyNtlmWorkstation) {
        this.builderProperties.set(PROXY_NTLM_WORKSTATION_KEY, proxyNtlmWorkstation);
        return this;
    }

    public boolean isTrustCert() {
        return Boolean.parseBoolean(this.builderProperties.get(TRUST_CERT_KEY));
    }

    public BlackDuckServerConfigBuilder setTrustCert(String trustCert) {
        this.builderProperties.set(TRUST_CERT_KEY, trustCert);
        return this;
    }

    public BlackDuckServerConfigBuilder setTrustCert(boolean trustCert) {
        this.setTrustCert(String.valueOf(trustCert));
        return this;
    }

    public BlackDuckRequestFactory getRequestFactory() {
        return this.blackDuckRequestFactory;
    }

    public void setRequestFactory(BlackDuckRequestFactory blackDuckRequestFactory) {
        this.blackDuckRequestFactory = blackDuckRequestFactory;
    }
}

