/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.bdio2upload;

import com.synopsys.integration.blackduck.codelocation.bdio2upload.UploadBdio2Callable;
import com.synopsys.integration.blackduck.codelocation.bdioupload.UploadBatch;
import com.synopsys.integration.blackduck.codelocation.bdioupload.UploadBatchOutput;
import com.synopsys.integration.blackduck.codelocation.bdioupload.UploadOutput;
import com.synopsys.integration.blackduck.codelocation.bdioupload.UploadTarget;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class UploadBdio2BatchRunner {
    private final IntLogger logger;
    private final BlackDuckApiClient blackDuckApiClient;
    private final BlackDuckRequestFactory blackDuckRequestFactory;
    private final ExecutorService executorService;

    public UploadBdio2BatchRunner(IntLogger logger, BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, ExecutorService executorService) {
        this.logger = logger;
        this.blackDuckApiClient = blackDuckApiClient;
        this.blackDuckRequestFactory = blackDuckRequestFactory;
        this.executorService = executorService;
    }

    public UploadBatchOutput executeUploads(UploadBatch uploadBatch) throws BlackDuckIntegrationException {
        this.logger.info("Starting the codelocation file uploads.");
        UploadBatchOutput uploadBatchOutput = this.uploadTargets(uploadBatch);
        this.logger.info("Completed the codelocation file uploads.");
        return uploadBatchOutput;
    }

    private UploadBatchOutput uploadTargets(UploadBatch uploadBatch) throws BlackDuckIntegrationException {
        ArrayList<UploadOutput> uploadOutputs = new ArrayList<UploadOutput>();
        try {
            List<UploadBdio2Callable> callables = this.createCallables(uploadBatch);
            ArrayList<Future<UploadOutput>> submitted = new ArrayList<Future<UploadOutput>>();
            for (UploadBdio2Callable uploadBdio2Callable : callables) {
                submitted.add(this.executorService.submit(uploadBdio2Callable));
            }
            for (Future future : submitted) {
                UploadOutput uploadOutput = (UploadOutput)future.get();
                uploadOutputs.add(uploadOutput);
            }
        }
        catch (Exception e) {
            throw new BlackDuckIntegrationException(String.format("Encountered a problem uploading a file: %s", e.getMessage()), e);
        }
        return new UploadBatchOutput((List<UploadOutput>)uploadOutputs);
    }

    private List<UploadBdio2Callable> createCallables(UploadBatch uploadBatch) {
        return uploadBatch.getUploadTargets().stream().map(uploadTarget -> new UploadBdio2Callable(this.blackDuckApiClient, this.blackDuckRequestFactory, (UploadTarget)uploadTarget)).collect(Collectors.toList());
    }
}

