/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BlackDuckRequestFilter {
    private final Map<String, Set<String>> filterKeysToValues = new HashMap<String, Set<String>>();

    public static BlackDuckRequestFilter createFilterWithMultipleValues(String key, List<String> values) {
        BlackDuckRequestFilter blackDuckRequestFilter = new BlackDuckRequestFilter();
        blackDuckRequestFilter.addFilter(key, values);
        return blackDuckRequestFilter;
    }

    public static BlackDuckRequestFilter createFilterWithSingleValue(String key, String value) {
        BlackDuckRequestFilter blackDuckRequestFilter = new BlackDuckRequestFilter();
        blackDuckRequestFilter.addFilter(key, value);
        return blackDuckRequestFilter;
    }

    public void addFilter(String key, String value) {
        this.filterKeysToValues.computeIfAbsent(key, k -> new HashSet()).add(value);
    }

    public void addFilter(String key, List<String> values) {
        this.filterKeysToValues.computeIfAbsent(key, k -> new HashSet()).addAll(values);
    }

    public List<String> getFilterParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        this.filterKeysToValues.forEach((filterKey, filterValues) -> filterValues.forEach(filterValue -> {
            String parameterString = String.format("%s:%s", filterKey, filterValue);
            parameters.add(parameterString);
        }));
        return parameters;
    }
}

