/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.bucket;

import com.synopsys.integration.blackduck.api.core.BlackDuckResponse;
import com.synopsys.integration.blackduck.api.core.response.LinkSingleResponse;
import com.synopsys.integration.blackduck.service.bucket.BlackDuckBucketItem;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BlackDuckBucket {
    private final Map<String, BlackDuckBucketItem<BlackDuckResponse>> bucket = new ConcurrentHashMap<String, BlackDuckBucketItem<BlackDuckResponse>>();

    public boolean contains(String uri) {
        return this.bucket.containsKey(uri);
    }

    public Set<String> getAvailableUris() {
        return this.bucket.keySet();
    }

    public BlackDuckBucketItem<BlackDuckResponse> get(String uri) {
        return this.bucket.get(uri);
    }

    public <T extends BlackDuckResponse> T get(String uri, Class<T> responseClass) {
        LinkSingleResponse<T> linkSingleResponse = new LinkSingleResponse<T>(uri, responseClass);
        return this.get(linkSingleResponse);
    }

    public <T extends BlackDuckResponse> T get(LinkSingleResponse<T> linkSingleResponse) {
        BlackDuckResponse blackDuckResponse;
        Optional<BlackDuckResponse> optionalBlackDuckResponse;
        BlackDuckBucketItem<BlackDuckResponse> bucketItem;
        String uri = linkSingleResponse.getLink();
        if (this.contains(uri) && (bucketItem = this.get(uri)).hasValidResponse() && (optionalBlackDuckResponse = bucketItem.getBlackDuckResponse()).isPresent() && (blackDuckResponse = optionalBlackDuckResponse.get()).getClass().equals(linkSingleResponse.getResponseClass())) {
            return this.getResponseFromBucket(bucketItem);
        }
        return null;
    }

    private <T extends BlackDuckResponse> T getResponseFromBucket(BlackDuckBucketItem<BlackDuckResponse> bucketItem) {
        return (T)((BlackDuckResponse)bucketItem.getBlackDuckResponse().orElse(null));
    }

    public Optional<BlackDuckResponse> getResponse(String uri) {
        return this.bucket.get(uri).getBlackDuckResponse();
    }

    public Optional<Exception> getError(String uri) {
        return this.bucket.get(uri).getE();
    }

    public void addValid(String uri, BlackDuckResponse blackDuckResponse) {
        this.bucket.put(uri, new BlackDuckBucketItem<BlackDuckResponse>(uri, blackDuckResponse));
    }

    public void addError(String uri, Exception e) {
        this.bucket.put(uri, new BlackDuckBucketItem(uri, e));
    }

    public boolean hasAnyErrors() {
        return this.bucket.values().stream().filter(BlackDuckBucketItem::hasException).findFirst().isPresent();
    }

    public BlackDuckBucketItem<BlackDuckResponse> remove(String uri) {
        return this.bucket.remove(uri);
    }
}

