/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.dataservice;

import com.synopsys.integration.blackduck.api.core.BlackDuckComponent;
import com.synopsys.integration.blackduck.api.generated.view.IssueView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionComponentView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionIssuesView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.manual.temporary.component.IssueRequest;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class IssueService
extends DataService {
    public IssueService(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger) {
        super(blackDuckApiClient, blackDuckRequestFactory, logger);
    }

    public List<ProjectVersionIssuesView> getIssuesForProjectVersion(ProjectVersionView projectVersionView) throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(projectVersionView, ProjectVersionView.ISSUES_LINK_RESPONSE);
    }

    public Optional<IssueView> getIssueByKey(ProjectVersionView projectVersionView, String issueKey) throws IntegrationException {
        Predicate<ProjectVersionIssuesView> issueKeyEquals = issue -> issue.getIssueId().equals(issueKey);
        List<ProjectVersionIssuesView> bomComponentIssues = this.blackDuckApiClient.getSomeMatchingResponses(projectVersionView, ProjectVersionView.ISSUES_LINK_RESPONSE, issueKeyEquals, 1);
        Optional projectVersionIssuesViewOptional = bomComponentIssues.stream().findAny();
        if (projectVersionIssuesViewOptional.isPresent()) {
            return Optional.ofNullable(this.getIssueView((ProjectVersionIssuesView)projectVersionIssuesViewOptional.get()));
        }
        return Optional.empty();
    }

    public IssueView getIssueView(ProjectVersionIssuesView projectVersionIssuesView) throws IntegrationException {
        HttpUrl issueUrl = projectVersionIssuesView.getHref();
        return this.blackDuckApiClient.getResponse(issueUrl, IssueView.class);
    }

    public void createIssueForComponent(ProjectVersionComponentView projectVersionComponentView, IssueRequest issueRequest) throws IntegrationException {
        HttpUrl createIssueUrl = projectVersionComponentView.getFirstLink("component-issues");
        this.blackDuckApiClient.post(createIssueUrl, (BlackDuckComponent)issueRequest);
    }

    public void updateIssue(IssueView issueView) throws IntegrationException {
        this.blackDuckApiClient.put(issueView);
    }
}

