/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.log;

import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.LogLevel;
import java.io.PrintStream;

public class PrintStreamIntLogger
extends IntLogger {
    private final PrintStream printStream;
    private LogLevel logLevel;

    public PrintStreamIntLogger(PrintStream printStream, LogLevel logLevel) {
        this.printStream = printStream;
        this.logLevel = logLevel;
    }

    @Override
    public void alwaysLog(String txt) {
        this.printStream.println(txt);
    }

    @Override
    public void info(String txt) {
        if (this.logLevel.isLoggable(LogLevel.INFO)) {
            this.printStream.println("INFO: " + txt);
        }
    }

    @Override
    public void error(Throwable t) {
        if (this.logLevel.isLoggable(LogLevel.ERROR)) {
            t.printStackTrace(this.printStream);
        }
    }

    @Override
    public void error(String txt, Throwable t) {
        if (this.logLevel.isLoggable(LogLevel.ERROR)) {
            this.printStream.println("ERROR: " + txt);
            t.printStackTrace(this.printStream);
        }
    }

    @Override
    public void error(String txt) {
        if (this.logLevel.isLoggable(LogLevel.ERROR)) {
            this.printStream.println("ERROR: " + txt);
        }
    }

    @Override
    public void warn(String txt) {
        if (this.logLevel.isLoggable(LogLevel.WARN)) {
            this.printStream.println("WARN: " + txt);
        }
    }

    @Override
    public void trace(String txt) {
        if (this.logLevel.isLoggable(LogLevel.TRACE)) {
            this.printStream.println("TRACE: " + txt);
        }
    }

    @Override
    public void trace(String txt, Throwable t) {
        if (this.logLevel.isLoggable(LogLevel.TRACE)) {
            this.printStream.println("TRACE: " + txt);
            t.printStackTrace(this.printStream);
        }
    }

    @Override
    public void debug(String txt) {
        if (this.logLevel.isLoggable(LogLevel.DEBUG)) {
            this.printStream.println("DEBUG: " + txt);
        }
    }

    @Override
    public void debug(String txt, Throwable t) {
        if (this.logLevel.isLoggable(LogLevel.DEBUG)) {
            this.printStream.println("DEBUG: " + txt);
            t.printStackTrace(this.printStream);
        }
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }
}

