/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.client;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.exception.ApiException;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.DefaultResponse;
import com.synopsys.integration.rest.response.ErrorResponse;
import com.synopsys.integration.rest.response.Response;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class IntHttpClient {
    public static final Supplier<SSLContext> SSL_CONTEXT_SUPPLIER = SSLContexts::createDefault;
    public static final String ERROR_MSG_PROXY_INFO_NULL = "A IntHttpClient's proxy information cannot be null.";
    public static final int DEFAULT_TIMEOUT = 120;
    protected final IntLogger logger;
    private final ProxyInfo proxyInfo;
    private final int timeoutInSeconds;
    private final boolean alwaysTrustServerCertificate;
    private final CredentialsProvider credentialsProvider;
    private final HttpClientBuilder clientBuilder;
    private final RequestConfig.Builder defaultRequestConfigBuilder;
    private final Map<String, String> commonRequestHeaders;
    private SSLContext sslContext;

    public IntHttpClient(IntLogger logger, int timeoutInSeconds, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo) {
        this(logger, timeoutInSeconds, alwaysTrustServerCertificate, proxyInfo, SSL_CONTEXT_SUPPLIER.get());
    }

    public IntHttpClient(IntLogger logger, int timeoutInSeconds, ProxyInfo proxyInfo, SSLContext sslContext) {
        this(logger, timeoutInSeconds, false, proxyInfo, sslContext);
    }

    public IntHttpClient(IntLogger logger, int timeoutInSeconds, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, CredentialsProvider credentialsProvider, HttpClientBuilder clientBuilder, RequestConfig.Builder defaultRequestConfigBuilder, Map<String, String> commonRequestHeaders) {
        this(logger, timeoutInSeconds, alwaysTrustServerCertificate, proxyInfo, credentialsProvider, clientBuilder, defaultRequestConfigBuilder, commonRequestHeaders, SSL_CONTEXT_SUPPLIER.get());
    }

    public IntHttpClient(IntLogger logger, int timeoutInSeconds, ProxyInfo proxyInfo, CredentialsProvider credentialsProvider, HttpClientBuilder clientBuilder, RequestConfig.Builder defaultRequestConfigBuilder, Map<String, String> commonRequestHeaders, SSLContext sslContext) {
        this(logger, timeoutInSeconds, false, proxyInfo, credentialsProvider, clientBuilder, defaultRequestConfigBuilder, commonRequestHeaders, sslContext);
    }

    private IntHttpClient(IntLogger logger, int timeoutInSeconds, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, SSLContext sslContext) {
        this(logger, timeoutInSeconds, alwaysTrustServerCertificate, proxyInfo, (CredentialsProvider)new BasicCredentialsProvider(), HttpClientBuilder.create(), RequestConfig.custom(), new HashMap<String, String>(), sslContext);
    }

    private IntHttpClient(IntLogger logger, int timeoutInSeconds, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, CredentialsProvider credentialsProvider, HttpClientBuilder clientBuilder, RequestConfig.Builder defaultRequestConfigBuilder, Map<String, String> commonRequestHeaders, SSLContext sslContext) {
        this.logger = logger;
        this.proxyInfo = proxyInfo;
        this.timeoutInSeconds = timeoutInSeconds;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
        this.credentialsProvider = credentialsProvider;
        this.clientBuilder = clientBuilder;
        this.defaultRequestConfigBuilder = defaultRequestConfigBuilder;
        this.commonRequestHeaders = commonRequestHeaders;
        this.sslContext = sslContext;
        if (0 >= timeoutInSeconds) {
            throw new IllegalArgumentException("The timeout must be greater than 0.");
        }
        if (null == logger) {
            throw new IllegalArgumentException("The logger instance may not be null.");
        }
        if (null == proxyInfo) {
            throw new IllegalArgumentException(ERROR_MSG_PROXY_INFO_NULL);
        }
        this.addBuilderConnectionTimes();
        this.addBuilderProxyInformation();
        this.addToHttpClientBuilder(clientBuilder, defaultRequestConfigBuilder);
        this.addBuilderCredentialsProvider();
        this.addBuilderSSLContext();
    }

    public final RequestBuilder createRequestBuilder(HttpMethod method) throws IntegrationException {
        return this.createRequestBuilder(method, null);
    }

    public final RequestBuilder createRequestBuilder(HttpMethod method, Map<String, String> additionalHeaders) throws IntegrationException {
        if (method == null) {
            throw new IntegrationException("Missing field 'method'");
        }
        RequestBuilder requestBuilder = RequestBuilder.create((String)method.name());
        HashMap<String, String> requestHeaders = new HashMap<String, String>(this.commonRequestHeaders);
        if (additionalHeaders != null && !additionalHeaders.isEmpty()) {
            requestHeaders.putAll(additionalHeaders);
        }
        for (Map.Entry header : requestHeaders.entrySet()) {
            requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
        }
        return requestBuilder;
    }

    public HttpUriRequest createHttpUriRequest(Request request) throws IntegrationException {
        if (request.getMethod() == null) {
            throw new IntegrationException("Missing the HttpMethod");
        }
        if (request.getUrl() == null) {
            throw new IntegrationException("Missing the HttpUrl");
        }
        RequestBuilder requestBuilder = RequestBuilder.create((String)request.getMethod().name());
        URIBuilder uriBuilder = new URIBuilder(request.getUrl().uri());
        Map<String, Set<String>> populatedQueryParameters = request.getPopulatedQueryParameters();
        populatedQueryParameters.forEach((paramKey, paramValues) -> paramValues.forEach(paramValue -> uriBuilder.addParameter(paramKey, paramValue)));
        try {
            requestBuilder.setUri(uriBuilder.build());
        }
        catch (URISyntaxException e) {
            throw new IntegrationException("Invalid url with parameters: " + uriBuilder.toString());
        }
        String acceptMimeType = Request.DEFAULT_ACCEPT_MIME_TYPE;
        Charset bodyEncoding = StandardCharsets.UTF_8;
        if (StringUtils.isNotBlank((CharSequence)request.getAcceptMimeType())) {
            acceptMimeType = request.getAcceptMimeType();
        }
        if (request.getBodyEncoding() != null) {
            bodyEncoding = request.getBodyEncoding();
        }
        if (HttpMethod.GET == request.getMethod() && (request.getHeaders() == null || request.getHeaders().isEmpty() || !request.getHeaders().containsKey("Accept"))) {
            requestBuilder.addHeader("Accept", acceptMimeType);
        }
        requestBuilder.setCharset(bodyEncoding);
        for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(header.getKey(), header.getValue());
        }
        for (Map.Entry<String, String> header : this.commonRequestHeaders.entrySet()) {
            requestBuilder.addHeader(header.getKey(), header.getValue());
        }
        HttpEntity entity = request.createHttpEntity();
        if (entity != null) {
            requestBuilder.setEntity(entity);
        }
        return requestBuilder.build();
    }

    public Response execute(Request request) throws IntegrationException {
        return this.execute(request, (HttpContext)new BasicHttpContext());
    }

    public Response execute(Request request, HttpContext httpContext) throws IntegrationException {
        HttpUriRequest httpUriRequest = this.createHttpUriRequest(request);
        return this.execute(httpUriRequest, httpContext);
    }

    public Response execute(HttpUriRequest request) throws IntegrationException {
        return this.execute(request, (HttpContext)new BasicHttpContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute(HttpUriRequest request, HttpContext httpContext) throws IntegrationException {
        Response response;
        long start = System.currentTimeMillis();
        this.logger.trace("starting request: " + request.getURI().toString());
        try {
            response = this.handleClientExecution(request, httpContext);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.logger.trace(String.format("completed request: %s (%d ms)", request.getURI().toString(), end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.logger.trace(String.format("completed request: %s (%d ms)", request.getURI().toString(), end - start));
        return response;
    }

    public Optional<Response> executeGetRequestIfModifiedSince(Request getRequest, long timeToCheck) throws IntegrationException, IOException {
        return this.executeGetRequestIfModifiedSince(getRequest, timeToCheck, (HttpContext)new BasicHttpContext());
    }

    public Optional<Response> executeGetRequestIfModifiedSince(Request getRequest, long timeToCheck, HttpContext httpContext) throws IntegrationException, IOException {
        Request headRequest = (Request)new Request.Builder(getRequest).method(HttpMethod.HEAD).build();
        long lastModifiedOnServer = 0L;
        try (Response headResponse = this.execute(this.createHttpUriRequest(headRequest));){
            headResponse.throwExceptionForError();
            lastModifiedOnServer = headResponse.getLastModified();
            this.logger.debug(String.format("Last modified on server: %d", lastModifiedOnServer));
        }
        catch (IntegrationException e) {
            this.logger.error("Couldn't get the Last-Modified header from the server.");
            throw e;
        }
        if (lastModifiedOnServer == timeToCheck) {
            this.logger.debug("The request has not been modified since it was last checked - skipping.");
            return Optional.empty();
        }
        return Optional.of(this.execute(this.createHttpUriRequest(getRequest), httpContext));
    }

    public final void logRequestHeaders(HttpUriRequest request) {
        String requestName = request.getClass().getSimpleName();
        this.logger.trace(requestName + " : " + request.toString());
        this.logHeaders(requestName, request.getAllHeaders());
    }

    public final void logResponseHeaders(HttpResponse response) {
        String responseName = response.getClass().getSimpleName();
        this.logger.trace(responseName + " : " + response.toString());
        this.logHeaders(responseName, response.getAllHeaders());
    }

    protected void addToHttpClientBuilder(HttpClientBuilder httpClientBuilder, RequestConfig.Builder defaultRequestConfigBuilder) {
    }

    protected void handleErrorResponse(HttpUriRequest request, Response response) {
    }

    private void addBuilderConnectionTimes() {
        this.defaultRequestConfigBuilder.setConnectTimeout(this.timeoutInSeconds * 1000);
        this.defaultRequestConfigBuilder.setSocketTimeout(this.timeoutInSeconds * 1000);
        this.defaultRequestConfigBuilder.setConnectionRequestTimeout(this.timeoutInSeconds * 1000);
    }

    private void addBuilderCredentialsProvider() {
        this.clientBuilder.setDefaultCredentialsProvider(this.credentialsProvider);
        this.clientBuilder.setDefaultRequestConfig(this.defaultRequestConfigBuilder.build());
    }

    private void addBuilderSSLContext() {
        try {
            HostnameVerifier hostnameVerifier;
            if (this.alwaysTrustServerCertificate) {
                this.logger.error("Automatically trusting server certificates - not recommended for production use.");
                this.sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
                hostnameVerifier = new NoopHostnameVerifier();
            } else {
                hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            }
            SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(this.sslContext, hostnameVerifier);
            this.clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void addBuilderProxyInformation() {
        if (this.proxyInfo.shouldUseProxy()) {
            this.defaultRequestConfigBuilder.setProxy(new HttpHost((String)this.proxyInfo.getHost().orElse(null), this.proxyInfo.getPort()));
            if (this.proxyInfo.hasAuthenticatedProxySettings()) {
                NTCredentials credentials = new NTCredentials((String)this.proxyInfo.getUsername().orElse(null), (String)this.proxyInfo.getPassword().orElse(null), (String)this.proxyInfo.getNtlmWorkstation().orElse(null), (String)this.proxyInfo.getNtlmDomain().orElse(null));
                this.credentialsProvider.setCredentials(new AuthScope((String)this.proxyInfo.getHost().orElse(null), this.proxyInfo.getPort()), (Credentials)credentials);
            }
        }
    }

    private Response handleClientExecution(HttpUriRequest request, HttpContext httpContext) throws IntegrationException {
        try {
            CloseableHttpClient client = this.clientBuilder.build();
            this.logRequestHeaders(request);
            CloseableHttpResponse closeableHttpResponse = client.execute(request, httpContext);
            DefaultResponse response = new DefaultResponse(request, client, closeableHttpResponse);
            this.logResponseHeaders((HttpResponse)closeableHttpResponse);
            if (response.isStatusCodeError()) {
                this.handleErrorResponse(request, response);
            }
            return response;
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    private void logHeaders(String requestOrResponseName, Header[] headers) {
        if (headers != null && headers.length > 0) {
            this.logger.trace(requestOrResponseName + " headers : ");
            for (Header header : headers) {
                this.logger.trace(String.format("Header %s : %s", header.getName(), header.getValue()));
            }
        } else {
            this.logger.trace(requestOrResponseName + " does not have any headers.");
        }
    }

    public void throwExceptionForError(Response response) throws IntegrationException {
        try {
            response.throwExceptionForError();
        }
        catch (IntegrationRestException e) {
            throw this.transformException(e);
        }
    }

    private IntegrationException transformException(IntegrationRestException e) {
        String httpResponseContent = e.getHttpResponseContent();
        Optional<ErrorResponse> optionalErrorResponse = this.extractErrorResponse(httpResponseContent);
        if (optionalErrorResponse.isPresent()) {
            ErrorResponse errorResponse = optionalErrorResponse.get();
            String apiExceptionErrorMessage = String.format("%s [HTTP Error]: %s", errorResponse.getErrorMessage(), e.getMessage());
            return new ApiException(e, apiExceptionErrorMessage, errorResponse.getErrorCode());
        }
        return e;
    }

    public Optional<ErrorResponse> extractErrorResponse(String responseContent) {
        if (StringUtils.isNotBlank((CharSequence)responseContent)) {
            try {
                String errorMessage = (String)JsonPath.read((String)responseContent, (String)"$.errorMessage", (Predicate[])new Predicate[0]);
                String errorCode = (String)JsonPath.read((String)responseContent, (String)"$.errorCode", (Predicate[])new Predicate[0]);
                if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{errorMessage, errorCode})) {
                    return Optional.of(new ErrorResponse(errorMessage, errorCode));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public HttpClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public RequestConfig.Builder getDefaultRequestConfigBuilder() {
        return this.defaultRequestConfigBuilder;
    }

    public Map<String, String> getCommonRequestHeaders() {
        return this.commonRequestHeaders;
    }

    public void addCommonRequestHeader(String key, String value) {
        this.commonRequestHeaders.put(key, value);
    }

    public void addCommonRequestHeaders(Map<String, String> commonRequestHeaders) {
        this.commonRequestHeaders.putAll(commonRequestHeaders);
    }

    public String removeCommonRequestHeader(String key) {
        return this.commonRequestHeaders.remove(key);
    }

    public IntLogger getLogger() {
        return this.logger;
    }
}

