#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import urllib

from org.apache.http.client import ClientProtocolException

from checkmarx.CheckmarxHTTPRequest import CheckmarxHTTPRequest

class CheckmarxClient(object):
    def __init__(self, http_connection, access_token=None):
        self.http_request = CheckmarxHTTPRequest(http_connection, access_token)
        self.username = http_connection["username"]
        self.password = http_connection["password"]

    @staticmethod
    def create_client(http_connection, access_token=None):
        return CheckmarxClient(http_connection, access_token)

    def login(self):
        login_endpoint = "/cxrestapi/auth/identity/connect/token"

        body = urllib.urlencode({
            "username": str(self.username),
            "password": str(self.password),
            "grant_type" : "password",
            "scope" : "sast_rest_api",
            "client_id": "resource_owner_client",
            "client_secret": "014DF517-39D1-4453-B7B3-9930C563627C"

        })

        try:
            login_response = self.http_request.post(login_endpoint, body,
                                                    contentType="application/x-www-form-urlencoded")
        except ClientProtocolException:
            raise Exception("URL is not valid")
        if not login_response.isSuccessful():
            reason = "Unknown"
            if login_response.status == 400:
                reason = "Bad request"
            elif login_response.status == 401:
                reason = "Unauthorized"
            elif login_response.status == 403:
                reason = "Forbidden"
            raise Exception("HTTP response code %s (%s)" % (login_response.status, reason))
        return login_response
