#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import sys

from checkmarx.task import *

try:
    validate_mandatory_field(checkmarxServer, "Checkmarx server ID must be provided")
    validate_mandatory_field(team, "Missing value for Team")
    validate_mandatory_field(projectName, "Missing value for Project Name")
    validate_mandatory_field(preset, "Missing value for Preset")
    validate_mandatory_field(configuration, "Missing value for Configuration")
    validate_mandatory_field(url, "Missing value for Git URL")
    validate_mandatory_field(branch, "Missing value for Git Branch")

    checkmarx_team_id = CheckmarxService.get_team_id_by_name(checkmarx_server=checkmarxServer, team_name=team)

    checkmarx_project_id = CheckmarxService.resolve_project(checkmarx_server=checkmarxServer, project_name=projectName,
                                                            team_id=checkmarx_team_id)

    checkmarx_preset_id = CheckmarxService.get_preset_id_by_name(checkmarx_server=checkmarxServer, preset_name=preset)

    checkmarx_config_id = CheckmarxService.get_config_id_by_name(checkmarx_server=checkmarxServer,
                                                                 config_name=configuration)

    git_formatted_url = CheckmarxService.format_url(url=url, user=username, user_pass=password, user_token=token)
    git_remote_post_body = CheckmarxService.create_remote_git_body(url=git_formatted_url, branch=branch)

    CheckmarxService.set_project_settings(checkmarx_server=checkmarxServer,
                                          project_id=checkmarx_project_id,
                                          preset_id=checkmarx_preset_id,
                                          engine_configuration_id=checkmarx_config_id)

    CheckmarxService.set_remote_settings(checkmarx_server=checkmarxServer,
                                         project_id=checkmarx_project_id, body=git_remote_post_body,
                                         source_control="git")

    checkmarx_scan = CheckmarxService.trigger_scan(checkmarx_server=checkmarxServer, project_id=checkmarx_project_id)

    scanId = checkmarx_scan["id"]
    status = BaseStatus.BASE_STATUS_IN_PROGRESS
    task.schedule("checkmarx/task/wait_for_build.py",1)
except Exception as e:
    add_comment("Exception occurred: %s " % e)
    sys.exit(1)