#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import time
import  java
import sys
import yaml

from checkmarx import CheckmarxService
from checkmarx.task.helper.constant import BaseStatus
from checkmarx.task.helper.constant import ScanStatus
from checkmarx.task.helper.risk_profile import *
from checkmarx.task import *

sleep_interval_sec = 30
scan_timeout_sec = timeThreshold*60

max_retry_count = scan_timeout_sec / sleep_interval_sec

retryAttempt = retryAttempt + 1

if retryAttempt <= max_retry_count:
    if status == BaseStatus.BASE_STATUS_COMPLETED or status == BaseStatus.BASE_STATUS_SUCCEEDED:
        task.setStatusLine("Scan Completed")

    elif (status == BaseStatus.BASE_STATUS_IN_PROGRESS or status == BaseStatus.BASE_STATUS_IN_RUNNING):
        if isCheckMarxOne:
            checkmarx_scan_status = CheckmarxService.get_scan_status(checkmarx_server=checkmarxOneServer,
                                                                     scan_id=scanId, is_checkmarx_one=True)
            status = get_checkmarxone_base_scan_status(scan_status=checkmarx_scan_status["status"])
        else:
            checkmarx_scan_status = CheckmarxService.get_scan_status(checkmarx_server=checkmarxServer,
                                                                     scan_id=scanId)
            status = get_base_scan_status(scan_status=checkmarx_scan_status["status"]["name"])

        if status == BaseStatus.BASE_STATUS_FAILED:
                add_comment("CheckmarxOne Scan is failed or canceled for scan id : %s. Can not retrieve result." % scanId)
                sys.exit(1)
        task.schedule("checkmarx/task/wait_for_build.py",sleep_interval_sec)
else:
    raise Exception(
            "Failed to get CxSAST Scan status. Task has been automatically aborted: reached the user-specified timeout ({} minutes)".format(
                scan_timeout_sec / 60))