#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import sys

from checkmarx.task import *
from checkmarx.task.helper.risk_profile import *
import time

try:
    validate_mandatory_field(checkmarxOneServer, "CheckmarxOne server ID must be provided")
    validate_mandatory_field(projectName, "Missing value for Project Name")
    validate_mandatory_field(gitUrl, "Missing value for Git URL")
    validate_mandatory_field(branch, "Missing value for Git Branch")

    checkmarxProjectId = CheckmarxService.check_project_name_or_create(checkmarx_server=checkmarxOneServer, project_name=projectName, create_project=True)

    git_remote_post_body = CheckmarxService.create_checkmarxone_scan_git_body(url=gitUrl, branch=branch, preset=sastPreset,
                                                                              sast=startSASTScan, sca=startSCAScan, user=username, user_pass=password, token=token, skip_sub_module=skipSubModule, project_id=checkmarxProjectId, project_tags=project_tags, scan_tags=scan_tags)

    checkmarx_scan = CheckmarxService.checkmarxone_trigger_scan(checkmarx_server=checkmarxOneServer, body=git_remote_post_body)
    scanId = checkmarx_scan["id"]
    task.setStatusLine("Waiting for scan to finish")
    status = BaseStatus.BASE_STATUS_IN_PROGRESS
    task.schedule("checkmarx/task/wait_for_build.py",1)

    if startSASTScan:
        scan_link = checkmarxOneServer['url']+"sast-results/"+str(checkmarxProjectId)+"/" + str(scanId)
        print("SAST Scan Link :")
        print("[%s](%s)" % (str(scanId), scan_link))
        print("\n")

    if startSCAScan:
        scan_link = checkmarxOneServer['url']+"results/"+  str(checkmarxProjectId) +"/"+ str(scanId) +"/sca?internalPath=%2Fpackages%2Fall"
        print("SCA Scan Link :")
        print("[%s](%s)" % (str(scanId), scan_link))

except Exception as e:
    add_comment("Exception occurred: %s " % e)
    sys.exit(1)
