#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import org.apache.http.conn.HttpHostConnectException

from checkmarx.task import *

try:
    validate_mandatory_field(projectName, "Missing value for Project Name")
    validate_mandatory_field(checkmarxServer, "Checkmarx server ID must be provided")
    validate_mandatory_field(title, "Missing value for Tile Title")

    checkmarx_project_id = CheckmarxService.check_project_name_or_create(checkmarx_server=checkmarxServer, project_name=projectName, create_project=False)

    if not scanId:
        project_scan_id = CheckmarxService.get_latest_sast_scan_id(checkmarx_server=checkmarxServer,
                                                                   project_id=projectName,is_checkmarx_one=True)
        checkmarx_scan_status = CheckmarxService.get_scan_status(checkmarx_server=checkmarxServer,
                                                                 scan_id=project_scan_id,is_checkmarx_one=True)
        checkmarx_scan_result = CheckmarxService.get_sast_results_stats(checkmarx_server=checkmarxServer,
                                                                        scan_id=project_scan_id,is_checkmarx_one=True)
    else:
        project_scan_id = scanId
        try:
            checkmarx_scan_status = CheckmarxService.get_scan_status(checkmarx_server=checkmarxServer,
                                                                     scan_id=project_scan_id,is_checkmarx_one=True)
        except Exception as e:
            error_message = "Invalid scan id provided. Can't retrieve Scan result for project {} with scan id {}.".format(projectName, scanId)
            raise Exception(error_message)

        if checkmarx_scan_status["projectId"] != checkmarx_project_id:
            error_message = "Can't retrieve Scan result for project {} with scan id {}.".format(projectName, project_scan_id)
            raise Exception(error_message)

        base_status = get_checkmarxone_base_scan_status(scan_status=checkmarx_scan_status["status"])
        if base_status == BaseStatus.BASE_STATUS_IN_RUNNING:
            error_message = "Scan is in progress for scan id : %s. Can not retrieve result." % project_scan_id
            raise Exception(error_message)
        elif base_status == BaseStatus.BASE_STATUS_FAILED:
            error_message = "Scan is failed or canceled for scan id : %s. Can not retrieve result." % project_scan_id
            raise Exception(error_message)
        else:
            checkmarx_scan_result = CheckmarxService.get_sast_results_stats(checkmarx_server=checkmarxServer,
                                                                            scan_id=project_scan_id, is_checkmarx_one=True)

    data = checkmarx_scan_result
    data['projectName'] = projectName
    data['projectId'] = checkmarx_project_id
    data['checkmarxUrl'] = checkmarxServer['url']
    data['scanId'] = project_scan_id
    data['scanRiskSeverity'] = {'highSeverity':0,'mediumSeverity': 0, 'lowSeverity': 0}
    data['scanSCARiskSeverity'] = {'highSeverity':0,'mediumSeverity': 0, 'lowSeverity': 0}
    data['isSCA'] = isSCA
    data['isSAST'] = isSAST
    #['infoSeverity', 'lowSeverity', 'mediumSeverity', 'highSeverity'];

    for severity in checkmarx_scan_result["scansSummaries"][0]["sastCounters"]["severityCounters"]:
        if severity["severity"] == "HIGH":
            data['scanRiskSeverity']['highSeverity'] = severity["counter"]
        if severity["severity"] == "MEDIUM":
            data['scanRiskSeverity']['mediumSeverity'] = severity["counter"]
        if severity["severity"] == "LOW":
            data['scanRiskSeverity']['lowSeverity'] = severity["counter"]

    for severity in checkmarx_scan_result["scansSummaries"][0]["scaCounters"]["severityCounters"]:
        if severity["severity"] == "HIGH":
            data['scanSCARiskSeverity']['highSeverity'] = severity["counter"]
        if severity["severity"] == "MEDIUM":
            data['scanSCARiskSeverity']['mediumSeverity'] = severity["counter"]
        if severity["severity"] == "LOW":
            data['scanSCARiskSeverity']['lowSeverity'] = severity["counter"]

except org.apache.http.conn.HttpHostConnectException as e:
    print("Connection Failed: {0} ".format(str(e)))
    data = {'error': [{'msg': e.getMessage()}]}

except Exception as e:
    print("Exception occurred: {0} ".format(str(e)))
    data = {'error': [{'msg': str(e)}]}
