#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import urllib

from org.apache.http.client import ClientProtocolException

from checkmarx.CheckmarxHTTPRequest import CheckmarxHTTPRequest

class CheckmarxClient(object):
    def __init__(self, http_connection, access_token=None):
        self.auth_type = http_connection["authenticationMethod"] if "authenticationMethod" in http_connection else None
        self.http_request = CheckmarxHTTPRequest(http_connection, access_token)
        self.username = http_connection["username"]
        self.password = http_connection["password"]
        self.clientId = http_connection["clientId"] if "clientId" in http_connection else None
        self.clientSecret = http_connection["clientSecret"] if "clientSecret" in http_connection else None
        if "account" in http_connection:
            self.account = http_connection["account"]

    @staticmethod
    def create_client(http_connection, access_token=None):
        return CheckmarxClient(http_connection, access_token)

    def login(self):
        login_endpoint = "/cxrestapi/auth/identity/connect/token"

        body = urllib.urlencode({
            "username": str(self.username),
            "password": str(self.password),
            "grant_type" : "password",
            "scope" : "sast_rest_api",
            "client_id": "resource_owner_client",
            "client_secret": "014DF517-39D1-4453-B7B3-9930C563627C"

        })

        try:
            login_response = self.http_request.post(login_endpoint, body,
                                                    contentType="application/x-www-form-urlencoded")
        except ClientProtocolException:
            raise Exception("URL is not valid")
        if not login_response.isSuccessful():
            reason = "Unknown"
            if login_response.status == 400:
                reason = "Bad request"
            elif login_response.status == 401:
                reason = "Unauthorized"
            elif login_response.status == 403:
                reason = "Forbidden"
            raise Exception("HTTP response code %s (%s)" % (login_response.status, reason))
        return login_response

    def loginSCA(self):
        login_endpoint = "/identity/connect/token"

        body = urllib.urlencode({
            "username": str(self.username),
            "password": str(self.password),
            "acr_values" : "Tenant:"+str(self.account),
            "grant_type" : "password",
            "scope" : "sca_api",
            "client_id": "sca_resource_owner"

        })

        try:
            login_response = self.http_request.post(login_endpoint, body,
                                                    contentType="application/x-www-form-urlencoded")
        except Exception as e:
            raise Exception("Oops!", e.__class__, "occurred.")
        if not login_response.isSuccessful():
            reason = "Unknown"
            if login_response.status == 400:
                reason = "Bad request"
            elif login_response.status == 401:
                reason = "Unauthorized"
            elif login_response.status == 403:
                reason = "Forbidden"
            raise Exception("HTTP response code %s (%s)" % (login_response.status, reason))
        return login_response

    def loginOne(self):
        login_endpoint = "/auth/realms/{}/protocol/openid-connect/token".format(self.account)

        if self.auth_type == "Basic":
            if not self.password:
                raise Exception("Password cannot be empty")
            body = urllib.urlencode({
                "grant_type" : "refresh_token",
                "refresh_token" : str(self.password),
                "client_id": "ast-app"
            })
        else:
            if not self.clientId or not self.clientSecret:
                raise Exception("Client ID or Client Secret cannot be empty")
            body = urllib.urlencode({
                "grant_type": "client_credentials",
                "client_id": str(self.clientId),
                "client_secret": str(self.clientSecret)
            })
        try:
            login_response = self.http_request.post(login_endpoint, body,
                                                    contentType="application/x-www-form-urlencoded")
        except Exception as e:
            raise Exception("Oops!", e.__class__, "occurred.")
        if not login_response.isSuccessful():
            reason = "Unknown"
            if login_response.status == 400:
                reason = "Bad request"
            elif login_response.status == 401:
                reason = "Unauthorized"
            elif login_response.status == 403:
                reason = "Forbidden"
            raise Exception("HTTP response code %s (%s)" % (login_response.status, reason))
        return login_response