#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
from com.xebialabs.xlrelease.domain.configuration import HttpConnection
from xlrelease.HttpRequest import HttpRequest


class CheckmarxHTTPRequest(HttpRequest):

    def __init__(self, params, access_token=None):
        modified_params = params.copy()
        modified_params['oauth2GrantType'] = None
        modified_params['username'] = None
        modified_params['insecure'] = 'False'
        if access_token:
            modified_params['password'] = access_token
            modified_params['authenticationMethod'] = 'Bearer'
            modified_params = HttpConnection(modified_params)
        else:
            modified_params['password'] = None
            modified_params['authenticationMethod'] = 'None'
            modified_params = HttpConnection(modified_params)
        super(CheckmarxHTTPRequest, self).__init__(params=modified_params)
