#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import json
import threading
from java.net import HttpCookie

from checkmarx.client.CheckmarxClient import CheckmarxClient


class CheckmarxClientUtil(object):
    __lock = threading.RLock()
    auth_cache = {}

    @staticmethod
    def create_checkmarx_client(container, access_token=None):
        return CheckmarxClient.create_client(container, access_token)

    @staticmethod
    def get_checkmarx_client(checkmarx_server, retry):
        params = CheckmarxClientUtil.get_configuration(checkmarx_server)
        access_token = CheckmarxClientUtil.get_access_token(params, retry)
        return CheckmarxClientUtil.create_checkmarx_client(checkmarx_server, access_token)

    @staticmethod
    def get(checkmarx_server, context, **options):
        checkmarx_client = CheckmarxClientUtil.get_checkmarx_client(checkmarx_server, retry=False)
        checkmarx_response = checkmarx_client.http_request.get(context, **options)
        if checkmarx_response.getStatus() == 401:
            checkmarx_client = CheckmarxClientUtil.get_checkmarx_client(checkmarx_server, retry=True)
            checkmarx_response = checkmarx_client.http_request.get(context, **options)
        return checkmarx_response

    @staticmethod
    def post(checkmarx_server, context, body, **options):
        checkmarx_client = CheckmarxClientUtil.get_checkmarx_client(checkmarx_server, retry=False)
        checkmarx_response = checkmarx_client.http_request.post(context, json.dumps(body), **options)
        if checkmarx_response.getStatus() == 401:
            checkmarx_client = CheckmarxClientUtil.get_checkmarx_client(checkmarx_server, retry=True)
            checkmarx_response = checkmarx_client.http_request.post(context, json.dumps(body), **options)
        return checkmarx_response

    @staticmethod
    def get_configuration(checkmarx_server):
        params = {'url': checkmarx_server.get('url'), 'username': checkmarx_server.get('username'),
                  'password': checkmarx_server.get('password'),
                  'proxyHost': checkmarx_server.get('proxyHost'), 'proxyPort': checkmarx_server.get('proxyPort'),
                  'proxyDomain': checkmarx_server.get('proxyDomain'), 'account': checkmarx_server.get('account'),
                  'serverEnvironment': checkmarx_server.get('serverEnvironment'),
                  'title': checkmarx_server.get('title'), 'id': checkmarx_server.get('id'),
                  'clientId': checkmarx_server.get('clientId'), 'clientSecret': checkmarx_server.get('clientSecret'),
                  'authenticationMethod': checkmarx_server.get('authenticationMethod')}
        return params

    @staticmethod
    def get_access_token(params, retry):
        # Added Lock to modify cookie data at a time by one thread
        # Removing it may cause login failure due to multiple request on checkmarx server
        with CheckmarxClientUtil.__lock:
            id = params['id']
            if id not in CheckmarxClientUtil.auth_cache:
                CheckmarxClientUtil.authenticate(id, params)
            elif retry \
                    or CheckmarxClientUtil.auth_cache[id]['access_token'] == "" :
                CheckmarxClientUtil.authenticate(id, params)

            access_token = CheckmarxClientUtil.auth_cache[id]['access_token']
            return access_token
    @staticmethod
    def authenticate(id, params):
        if params['account']:
            if params['serverEnvironment']:
                if params['serverEnvironment'] == "US":
                    params['url'] = "https://platform.checkmarx.net"
                else:
                    params['url'] = "https://eu.platform.checkmarx.net"

                checkmarx_client = CheckmarxClientUtil.create_checkmarx_client(params)
                response = checkmarx_client.loginSCA()
            else:
                if ".ast." in params['url']:
                    params['url'] = params['url'].replace(".ast.", ".iam.")
                else:
                    params['url'] = params['url']
                checkmarx_client = CheckmarxClientUtil.create_checkmarx_client(params)
                response = checkmarx_client.loginOne()
        else:
            checkmarx_client = CheckmarxClientUtil.create_checkmarx_client(params)
            response = checkmarx_client.login()
        responseTokenFull = json.loads(response.getResponse())
        access_token =  responseTokenFull.get("access_token")
        CheckmarxClientUtil.auth_cache[id] = {
            'access_token': access_token
        }

