#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import logging

from checkmarx.task import *

from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

logger = logging.getLogger("ListProjects")
logger.addHandler(logging.StreamHandler(sys.stdout))

output = CheckmarxService.get_projects_list(checkmarx_server=checkmarxOneServer)

project_list = []

projects = output["projects"]
for project in projects:
    project_list.append(LookupResultElement(project['name'], project['name']))

result = project_list