#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import org.apache.http.conn.HttpHostConnectException

from checkmarx.task import *

try:
    validate_mandatory_field(checkmarxServer, "Checkmarx server ID must be provided")
    validate_mandatory_field(team, "Missing value for Team")
    validate_mandatory_field(projectName, "Missing value for Project Name")
    validate_mandatory_field(riskType, "Missing value for Risk Type")

    checkmarx_team_id = CheckmarxService.get_team_id_by_name(checkmarx_server=checkmarxServer, team_name=team)

    project_list = CheckmarxService.get_project(checkmarx_server=checkmarxServer, project_name=projectName,
                                                team_id=checkmarx_team_id)
    if project_list:
        checkmarx_project_id = project_list[0]["id"]
    else:
        raise Exception("Could not get project data for : %s" % projectName)

    if not scanId:
        osa_scan_status = CheckmarxService.get_latest_osa_scan(checkmarx_server=checkmarxServer,
                                                               project_id=checkmarx_project_id)
        internal_scan_id = osa_scan_status["id"]
    else:
        internal_scan_id = scanId
        osa_scan_status = CheckmarxService.get_osa_scan_status(checkmarx_server=checkmarxServer,
                                                               scan_id=internal_scan_id)
        if osa_scan_status["state"]["name"] != BaseStatus.BASE_STATUS_SUCCEEDED:
            raise Exception(
                "CxOSA Scan is in progress or failed for scan id : %s. Can not retrieve result." % internal_scan_id)

    osa_scan_result = CheckmarxService.get_osa_results_stats(checkmarx_server=checkmarxServer,
                                                             scan_id=internal_scan_id)
    osa_scan_library_data = CheckmarxService.get_osa_libraries_data(checkmarx_server=checkmarxServer,
                                                                    scan_id=internal_scan_id)

    data = osa_scan_result
    data.update(osa_scan_library_data)
    data['projectName'] = projectName
    data['projectId'] = checkmarx_project_id
    data['team'] = team
    data['checkmarxUrl'] = checkmarxServer['url']
    data['scanId'] = internal_scan_id
    data['statisticsCalculationDate'] = osa_scan_status['startAnalyzeTime']
    data['dataChart'] = 'security' if riskType == 'Security Risks' else 'license'

except org.apache.http.conn.HttpHostConnectException as e:
    print("Connection Failed: {0} ".format(str(e)))
    data = {'error': [{'msg': e.getMessage()}]}

except Exception as e:
    print("Exception occurred: {0} ".format(str(e)))
    data = {'error': [{'msg': str(e)}]}
