/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.util;

import com.cyberark.conjur.util.TextUtils;
import java.util.Collection;

public class Args {
    private static final String NULL_ERROR = "may not be null";
    private static final String EMPTY_ERROR = "may not be empty";
    private static final String BLANK_ERROR = "may not be blank";
    private static final String POSITIVE_ERROR = "must be positive";
    private static final String NEGATIVE_ERROR = "may not be negative";

    public static void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void check(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static <T> T notNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " " + NULL_ERROR);
        }
        return argument;
    }

    public static <T extends CharSequence> T notEmpty(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " " + NULL_ERROR);
        }
        if (TextUtils.isEmpty(argument)) {
            throw new IllegalArgumentException(name + " " + EMPTY_ERROR);
        }
        return argument;
    }

    public static <T extends CharSequence> T notBlank(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " " + NULL_ERROR);
        }
        if (TextUtils.isBlank(argument)) {
            throw new IllegalArgumentException(name + " " + BLANK_ERROR);
        }
        return argument;
    }

    public static <E, T extends Collection<E>> T notEmpty(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " " + NULL_ERROR);
        }
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(name + " " + EMPTY_ERROR);
        }
        return argument;
    }

    public static int positive(int n, String name) {
        if (n <= 0) {
            throw new IllegalArgumentException(name + " " + POSITIVE_ERROR);
        }
        return n;
    }

    public static long positive(long n, String name) {
        if (n <= 0L) {
            throw new IllegalArgumentException(name + " " + POSITIVE_ERROR);
        }
        return n;
    }

    public static int notNegative(int n, String name) {
        if (n < 0) {
            throw new IllegalArgumentException(name + " " + NEGATIVE_ERROR);
        }
        return n;
    }

    public static long notNegative(long n, String name) {
        if (n < 0L) {
            throw new IllegalArgumentException(name + " " + NEGATIVE_ERROR);
        }
        return n;
    }

    public static <T> T notNull(T value) {
        return Args.notNull(value, "argument");
    }
}

