/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.api;

import com.cyberark.conjur.api.Credentials;
import com.cyberark.conjur.util.Args;
import com.cyberark.conjur.util.Properties;
import java.io.Serializable;
import java.net.URI;

public class Endpoints
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final URI authnUri;
    private final URI secretsUri;

    public Endpoints(URI authnUri, URI secretsUri) {
        this.authnUri = Args.notNull(authnUri, "authnUri");
        this.secretsUri = Args.notNull(secretsUri, "secretsUri");
    }

    public Endpoints(String authnUri, String secretsUri) {
        this(URI.create(authnUri), URI.create(secretsUri));
    }

    public URI getAuthnUri() {
        return this.authnUri;
    }

    public URI getSecretsUri() {
        return this.secretsUri;
    }

    public static Endpoints fromSystemProperties() {
        String account = Properties.getMandatoryProperty("CONJUR_ACCOUNT");
        String applianceUrl = Properties.getMandatoryProperty("CONJUR_APPLIANCE_URL");
        String authnUrl = Properties.getMandatoryProperty("CONJUR_AUTHN_URL", applianceUrl + "/authn");
        return new Endpoints(Endpoints.getAuthnServiceUri(authnUrl, account), Endpoints.getServiceUri("secrets", account, "variable"));
    }

    public static Endpoints fromCredentials(Credentials credentials) {
        String account = Properties.getMandatoryProperty("CONJUR_ACCOUNT");
        return new Endpoints(Endpoints.getAuthnServiceUri(credentials.getAuthnUrl(), account), Endpoints.getServiceUri("secrets", account, "variable"));
    }

    private static URI getAuthnServiceUri(String authnUrl, String accountName) {
        return URI.create(String.format("%s/%s", authnUrl, accountName));
    }

    private static URI getServiceUri(String service, String accountName, String path) {
        return URI.create(String.format("%s/%s/%s/%s", Properties.getMandatoryProperty("CONJUR_APPLIANCE_URL"), service, accountName, path));
    }

    public String toString() {
        return "Endpoints{authnUri=" + this.authnUri + "secretsUri=" + this.secretsUri + '}';
    }
}

