#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import json
from xlrelease.HttpRequest import HttpRequest
import org.slf4j.LoggerFactory as LoggerFactory

logger = LoggerFactory.getLogger("CRP")


def getChangeRiskPrediction(serverParams, changeRequestNumber, projectName, CRPModel):
    api_end_point = '/store/ml/prediction/%s/%s' % (projectName,CRPModel)
    body = {
        "businessIds": []
    }
    body["businessIds"].append(changeRequestNumber)
    response = HttpRequest(serverParams).post(context=str(api_end_point),body=json.dumps(body),contentType='application/json',headers={})
    if response.status >= 400:
        raise Exception(
            "Error retrieving change risk prediction value from Change Risk Prediction Server. Status: %s" % response.status
        )

    else:
        # convert the response to json
        crp_value = getJSONValueFromResponseContent(response.response)
        return crp_value

def getJSONValueFromResponseContent(responseContent):
    data = json.loads(responseContent)
    predictions = data['predictions']

    for change_id, info in predictions.items():
        print "Change ID: {}".format(change_id)
        print "Last Updated On: {}".format(info['last_updated_on'] if info['last_updated_on'] else 'N/A')
        if info['message']:
            print "Message: {}".format(info['message'])
        returnValue =  info['value']

    return returnValue
