from org.apache.http.client import ClientProtocolException
from xlrelease.HttpRequest import HttpRequest

global configuration

params = {
    'url': configuration.url,
    'authenticationMethod': configuration.authenticationMethod,
    'username': configuration.username,
    'password': configuration.password,
    'domain': configuration.domain,
    'oauth2GrantType': configuration.oauth2GrantType,
    'accessTokenUrl': configuration.accessTokenUrl,
    'clientId': configuration.clientId,
    'clientSecret': configuration.clientSecret,
    'scope': configuration.scope,
    'proxyHost': configuration.proxyHost,
    'proxyPort': configuration.proxyPort,
    'proxyUsername': configuration.proxyUsername,
    'proxyPassword': configuration.proxyPassword
}

try:
    request = HttpRequest(params)
    response = request.get("identity/v1/users/self")
except ClientProtocolException:
    raise Exception("URL is not valid")

if not response.isSuccessful():
    reason = "Unknown"
    if response.status == 400:
        reason = "Bad request"
    elif response.status == 401:
        reason = "Unauthorized"
    elif response.status == 403:
        reason = "Forbidden"
    raise Exception("HTTP response code %s (%s)" % (response.status, reason))
