"use strict";

(function () {
    var injectParams = ['Backend'];
    var XlrDashboardService = function XlrDashboardService(Backend) {

        function loadConfiguration(dashboardId) {
            return Backend.get("dashboards/" + dashboardId);
        }

        function save(dashboard) {
            return Backend.put("dashboards/" + dashboard.id, dashboard);
        }

        function tileTypes() {
            return Backend.get('tiles/tile-types');
        }

        function saveTile(tile) {
            return Backend.put("tiles/" + tile.id, tile);
        }

        function loadTile(tileId) {
            return Backend.get("tiles/" + tileId);
        }

        return {
            loadConfiguration: loadConfiguration,
            tileTypes: tileTypes,
            save: save,
            saveTile: saveTile,
            loadTile: loadTile
        };
    };

    XlrDashboardService.$inject = injectParams;

    angular.module('xlrelease.dashboard').service('xlrelease.XlrDashboardService', XlrDashboardService);
})();