'use strict';

(function () {
    var injectParams = ['$scope', '$q', '$routeParams', 'Ids', 'Authenticator', 'ReleasesService', 'xlrDashboardConfigProvider', 'xlrelease.XlrDashboardService', 'VariablesService'];
    var XlrDashboardController = function XlrDashboardController($scope, $q, $routeParams, Ids, Authenticator, ReleasesService, xlrDashboardConfigProvider, XlrDashboardService, VariablesService) {
        var vm = this;
        var releasePageExtensionCtrl = $scope.releasePageExtensionCtrl;

        vm.release = releasePageExtensionCtrl.release;
        vm.canEditDashboard = Authenticator.hasEditPermission(vm.release) && !ReleasesService.isReleaseArchived(vm.release);
        vm.showAddTileModal = false;
        vm.dashboardMode = 'view'; // 'view', 'design'
        vm.gridsterOpts = xlrDashboardConfigProvider.getConfig(false);
        vm.dashboard = {
            id: Ids.toDomainId($routeParams.releaseId) + "/" + $routeParams.extensionPath,
            tiles: []
        };

        vm.addTile = addTile;
        vm.removeTile = removeTile;
        vm.saveTile = saveTile;
        vm.modeSwitch = modeSwitch;
        vm.saveDashboard = saveDashboard;

        init();

        ///

        function init() {
            $q.all([loadTiles(), loadTileTypes(), loadAllVariables()]).then(function () {
                vm.initialized = true;
            });
        }

        function loadTiles() {
            return XlrDashboardService.loadConfiguration(vm.dashboard.id).then(function (response) {
                if (!_.isEmpty(response.data)) {
                    vm.dashboard = response.data;
                }
            });
        }

        function loadTileTypes() {
            return XlrDashboardService.tileTypes().then(function (response) {
                vm.tileTypes = response.data;
                vm.tileTypeDefs = _.reduce(vm.tileTypes, function (memo, it) {
                    it.property = _.indexBy(it.properties, 'name');
                    memo[it.type] = it;
                    return memo;
                }, {});
            });
        }

        function loadAllVariables() {
            return VariablesService.getAllVariables($routeParams.releaseId).then(function (allVariables) {
                vm.allVariables = allVariables;
            });
        }

        function modeSwitch() {
            vm.dashboardMode = vm.dashboardMode === 'view' ? 'design' : 'view';
            vm.gridsterOpts = xlrDashboardConfigProvider.getConfig(vm.dashboardMode === 'design');
        }

        function newTile(tileType) {
            return {
                id: null,
                type: tileType,
                title: vm.tileTypeDefs[tileType].property.title.default,
                uri: vm.tileTypeDefs[tileType].property.uri.default
            };
        }

        function saveDashboard() {
            XlrDashboardService.save(vm.dashboard).then(function (response) {
                vm.dashboard = response.data;
                modeSwitch();
            });
        }

        function addTile(tileType) {
            if (tileType) {
                var changedDashboard = angular.copy(vm.dashboard);
                changedDashboard.tiles.push(newTile(tileType));
                XlrDashboardService.save(changedDashboard).then(function (response) {
                    vm.dashboard = response.data;
                });
            }
        }

        function removeTile(item) {
            var changedDashboard = angular.copy(vm.dashboard);
            var tileIndex = _.findIndex(vm.dashboard.tiles, { id: item.id });
            changedDashboard.tiles.splice(tileIndex, 1);
            XlrDashboardService.save(changedDashboard).then(function (response) {
                vm.dashboard = response.data;
            });
        }

        function saveTile(tile) {
            XlrDashboardService.saveTile(tile).then(function (response) {
                var updatedTile = response.data;
                var tileIndex = _.findIndex(vm.dashboard.tiles, { id: updatedTile.id });
                if (tileIndex >= 0) {
                    vm.dashboard.tiles[tileIndex] = updatedTile;
                } else {
                    vm.dashboard.tiles.push(updatedTile);
                }
                vm.tile = updatedTile;
            });
        }
    };

    XlrDashboardController.$inject = injectParams;

    var XlrDashboard = function XlrDashboard() {
        return {
            transclude: true,
            templateUrl: 'static/5.0.1/include/DashboardPage/xlr-dashboard.html',
            controller: 'xlrelease.dashboard.XlrDashboardController',
            controllerAs: 'xlrDashboard'
        };
    };

    angular.module('xlrelease.dashboard').directive('xlrDashboard', XlrDashboard);
    angular.module('xlrelease.dashboard').controller('xlrelease.dashboard.XlrDashboardController', XlrDashboardController);
})();