#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from contextlib import closing

from java.lang import Exception as JException

global configuration

message = "Unable to connect to Delivery Insights Service at {}. Please ensure connection details " \
          "are correct.".format(configuration.url)
with closing(configuration.getClient()) as client:
    try:
        res = client.checkConnection()
        if not res:
            raise RuntimeError(message)
    except JException as e:
        raise RuntimeError(message)
