#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#
import sys

from contextlib import closing

from continuum import get_client
from com.xebialabs.xlrelease.plugin.continuum import GetPackageRevisionManifestRequest

global task
global pipeline_instance_id
global package
global pipeline_status
global definition
global continuumServer


def pipeline_link(server_url, pipeline_definition, pipeline_instance_id):
    pipeline_title = "{} ({})".format(pipeline_definition, pipeline_instance_id)
    pipeline_url = "{}/flow/pi_detail?id={}".format(server_url.rstrip("/"), pipeline_instance_id)
    return "[{}]({})".format(pipeline_title, pipeline_url)


with closing(get_client(task)) as client:
    resp = client.getPipelineInstance(pipeline_instance_id).Response()
    instance_status = resp.get("status", "")
    task.setStatusLine("Status: {}.".format(instance_status))
    if instance_status not in ["success", "failure", "canceled"]:
        task.schedule("continuum/TrackCode.wait.py")
    else:
        revision = resp.get("created_revisions").get(0).get("revision", "")
        pipeline_status = instance_status
        pipeline_md = pipeline_link(continuumServer["url"], definition, pipeline_instance_id)
        print "Pipeline {} has ended with status: {}".format(pipeline_md, pipeline_status)
        if instance_status in ["failure", "canceled"]:
            sys.exit(1)  # fail the task

        package_revision_manifest = client.getPackageRevisionManifest(GetPackageRevisionManifestRequest(package, str(revision))).Response()
        changes = package_revision_manifest.get("changes")
        workitems = package_revision_manifest.get("workitems")
        print "Count of commits found: %s" % len(changes)
        for change in changes:
            print "[{}]({}): {}".format(change.get("external_id")[:6], change.get("external_url"), change.get("message"))
        print "Count of work items found: %s" % len(workitems)
        for workitem in workitems:
            print "[{}]({}): {}".format(workitem.get("external_key"), workitem.get("external_url"), workitem.get("title").encode('utf-8'))
