/**
 * Copyright (c) 2023. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
 */
package com.xebialabs.xlrelease.plugin.platform.utils

import com.xebialabs.deployit.util.PasswordEncrypter

object StringUtils {

  implicit class UtilsString(input: String) {
    def orElse(default: String): String = Option(input).getOrElse(default)

    def decrypt: String = if (input != null) PasswordEncrypter.getInstance().ensureDecrypted(input) else null
  }


}
