#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement
from contextlib import closing

applications = []
with closing(_ci.getClient()) as client:
    resp = client.listApplications().results()
    applications = [{"id": p["id"], "package_name": p["package_name"]} for p in resp]

result = [LookupResultElement(p["package_name"], p["id"]) for p in applications]
