#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

# Post data to /insight/v1/packages/{package_id}/revisions/ in order to turn an
# unfinalized package (aka bucket) into a finalized one.


from contextlib import closing

import java.util.HashMap as HashMap
from com.xebialabs.xlrelease.plugin.platform import \
    CreatePackageRevisionRequest
from scala.jdk.javaapi import CollectionConverters

# "Injected" variables:

global task
global platformServer

global application  # application id
global phase  # phase id
global branch
global version
global alias


# We cannot import code from a common module, therefore we replicate the following
# function everywhere we need it. You are welcome.
def get_client(task):
    python_script = task.pythonScript
    return python_script.getClient()


with closing(get_client(task)) as client:
    task.setStatusLine("Loading application information...")
    app_response = client.getApplication(application)
    progression_id = app_response["progression_id"] if app_response else None
    package_id = app_response["package_id"] if app_response else None
    repository_id = app_response["repository_id"] if app_response else None

    if version is None:
        version = branch

    task.setStatusLine("Creating a new revision...")
    resp = client.createPackageRevision(package_id, CreatePackageRevisionRequest(progression_id, phase, repository_id, branch, version, alias))

    revision_id = resp["id"]
    revision = resp["revision"]

    task.setStatusLine("Revision ID: {} Revision: {}.".format(revision_id, revision))

