/**
 * Copyright (c) 2023. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
 */
package com.xebialabs.xlrelease.plugin.platform.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.plugin.platform.Client;

@Metadata(label = "Platform Python Script", virtual = true)
public class PlatformPythonScript extends PythonScript {

    @Property(category = "input", label = "Insights Service", description = "Delivery Insights Service to connect to")
    private PlatformServer platformServer;

    @Property(required = false, password = true, category = "input", label = "API Token", description = "Overrides the API token used to connect to the server")
    private String apiToken;

    public PlatformServer getPlatformServer() {
        return platformServer;
    }

    public void setPlatformServer(final PlatformServer platformServer) {
        this.platformServer = platformServer;
    }

    public String getApiToken() {
        return apiToken;
    }

    public void setApiToken(final String apiToken) {
        this.apiToken = apiToken;
    }

    public Client getClient() {
        return Client.apply(this);
    }
}
