/**
 * Copyright (c) 2023. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
 */
package com.xebialabs.xlrelease.plugin.platform.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.configuration.HttpConnection;
import com.xebialabs.xlrelease.plugin.platform.Client;

@Metadata(label = "Delivery Insights Service")
public class PlatformServer extends HttpConnection {

    @Property(description = "Script Location", required = false, hidden = true, defaultValue = "platform/CheckConnection.py")
    private String scriptLocation;

    @Property(label = "Api Token", password = true, required = true, category = "Authentication")
    private String apiToken;

    @Property(label = "Authentication Method", required = false, hidden = true, defaultValue = "None")
    private AuthenticationMethod authenticationMethod;

    @Property(label = "Connection Timeout (Seconds)", required = false, description = "Connection Timeout", defaultValue = "60")
    private Integer timeOutSeconds;

    @Property(required = false, description = "Login user ID on the server", category = "Authentication", hidden = true)
    private String username;

    @Property(password = true, required = false, description = "Login user password on the server", category = "Authentication", hidden = true)
    private String password;

    @Property(description = "Domain to be used for NTLM authentication", required = false, label = "Domain", category = "Authentication", hidden = true)
    private String domain;

    @Property(required = false, description = "HTTP proxy host", category = "Proxy")
    private String proxyHost;

    @Property(required = false, description = "HTTP proxy port", category = "Proxy")
    private String proxyPort;

    @Property(required = false, description = "HTTP proxy username", category = "Proxy")
    private String proxyUsername;

    @Property(password = true, required = false, description = "HTTP proxy password", category = "Proxy")
    private String proxyPassword;

    public String getApiToken() {
        return apiToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    @Override
    public AuthenticationMethod getAuthenticationMethod() {
        return authenticationMethod;
    }

    @Override
    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    @Override
    public String getDomain() {
        return domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getTimeOutSeconds() {
        return timeOutSeconds;
    }

    public void setTimeOutSeconds(Integer timeOutSeconds) {
        this.timeOutSeconds = timeOutSeconds;
    }

    public Client getClient() {
        return Client.apply(this);
    }

}
