/**
 * Copyright (c) 2023. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
 */
package com.xebialabs.xlrelease.plugin

import java.util

package object platform {
  type MapResponseType = java.util.Map[String, Object]

  type ListMapResponseType = java.util.List[MapResponseType]

  def defaultListOfMap = new util.ArrayList[MapResponseType]()
  def defaultMap = new util.HashMap[String, Object]()

  implicit class ResponseMap(o: java.util.Map[String, Object]) {

    def getInt(key: String): Int = {
      o.get(key).asInstanceOf[Int]
    }

    def getString(key: String): String = {
      o.get(key).asInstanceOf[String]
    }

    def getObject(key: String): MapResponseType = {
      o.getOrDefault(key, defaultMap).asInstanceOf[MapResponseType]
    }

    def getListOfObjects(key: String): ListMapResponseType = {
      o.getOrDefault(key, defaultListOfMap).asInstanceOf[ListMapResponseType]
    }

  }
}
