package com.xebialabs.xlrelease.plugin.platform.domain;

import java.util.HashMap;
import java.util.Map;

public enum RemovalReason {
    DELIVERED,
    OTHER;

    private static final Map<String, RemovalReason> map = new HashMap<>(values().length, 1);
    static {
        for (RemovalReason removalReason : values())
            map.put(removalReason.name().toLowerCase(), removalReason);
    }
    public static RemovalReason getRemovalReasonOf(String name) {
        if(name!=null)
            return map.getOrDefault(name.toLowerCase(), OTHER);
        return OTHER;
    }
}
