/**
 * Copyright (c) 2023. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
 */
package com.xebialabs.xlrelease.plugin.platform.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.plugin.platform.Client;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile;

@Metadata(virtual = true)
public class PlatformTile extends Tile {

    @Property(category = "input", label = "Insights Service", description = "Delivery Insights Service")
    private PlatformServer server;

    public PlatformServer getServer() {
        return server;
    }

    public void setServer(final PlatformServer server) {
        this.server = server;
    }

    public Client getClient() {
        return this.server.getClient();
    }
}
