/**
 * Copyright (c) 2023. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
 */
package com.xebialabs.xlrelease.plugin.platform

import com.xebialabs.deployit.engine.spi.exception.{DeployitException, HttpResponseCodeResult}
import org.apache.http.HttpStatus

@HttpResponseCodeResult(statusCode = 400)
case class ServerException(msg: String, cause: Throwable = null, statusCode: Int = HttpStatus.SC_INTERNAL_SERVER_ERROR)
  extends DeployitException(msg, cause)
