/**
 * Copyright (c) 2023. All rights reserved.
 *
 * This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
 */
package com.xebialabs.xlrelease.plugin.platform.serializer

import com.fasterxml.jackson.core.JsonGenerator
import com.fasterxml.jackson.databind.{JsonSerializer, SerializerProvider}

import scala.jdk.CollectionConverters._

// helpers for serializing, they might not be used, but let's leave them here for future use
class ScalaListSerializer extends JsonSerializer[List[_]] {
  override def serialize(value: List[_], gen: JsonGenerator, serializers: SerializerProvider): Unit = {
    gen.writeObject(value.asJava)
  }
}

class ScalaSeqSerializer extends JsonSerializer[Seq[_]] {
  override def serialize(value: Seq[_], gen: JsonGenerator, serializers: SerializerProvider): Unit = {
    gen.writeObject(value.asJava)
  }
}
