#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

# Post data to /insight/v1/promotions/ in order to promote a revision
# from one (given) phase to another (given) phase.


from contextlib import closing

from com.xebialabs.xlrelease.plugin.platform import \
    PromoteAPackageRequest

# "Injected" variables:

global task
global platformServer

global application  # application id
global phase_from  # phase id
global phase_to  # phase id
global revision

# We cannot import code from a common module, therefore we replicate the following
# function everywhere we need it. You are welcome.
def get_client(task):
    python_script = task.pythonScript
    return python_script.getClient()


with closing(get_client(task)) as client:
    task.setStatusLine("Loading application information...")
    app_response = client.getApplication(application)
    progression_id = app_response["progression_id"] if app_response else None
    package_id = app_response["package_id"] if app_response else None

    task.setStatusLine("Promoting revision...")
    resp = client.promoteAPackage(PromoteAPackageRequest(package_id, revision, phase_from, phase_to, progression_id))

    task.setStatusLine("Revision promoted: {}.".format(revision))
