#
# Copyright 2018 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-appdata-container.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.DatabaseContainer import DatabaseContainer
from delphixpy import factory
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

_UNDEFINED = __Undef()

class AppDataContainer(DatabaseContainer):
    """
    *(extends* :py:class:`delphixpy.web.vo.DatabaseContainer` *)* Data
    container for AppData.
    """
    def __init__(self, undef_enabled=True):
        super(AppDataContainer, self).__init__()
        self._type = ("AppDataContainer", True)
        self._guid = (self.__undef__, True)
        self._toolkit = (self.__undef__, True)
        self._runtime = (self.__undef__, True)

    API_VERSION = "1.10.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(AppDataContainer, cls).from_dict(data, dirty, undef_enabled)
        obj._guid = (data.get("guid", obj.__undef__), dirty)
        if obj._guid[0] is not None and obj._guid[0] is not obj.__undef__:
            assert isinstance(obj._guid[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._guid[0]))
            common.validate_format(obj._guid[0], "None", None, None)
        obj._toolkit = (data.get("toolkit", obj.__undef__), dirty)
        if obj._toolkit[0] is not None and obj._toolkit[0] is not obj.__undef__:
            assert isinstance(obj._toolkit[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._toolkit[0]))
            common.validate_format(obj._toolkit[0], "None", None, None)
        if "runtime" in data and data["runtime"] is not None:
            obj._runtime = (factory.create_object(data["runtime"], "AppDataContainerRuntime"), dirty)
            factory.validate_type(obj._runtime[0], "AppDataContainerRuntime")
        else:
            obj._runtime = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(AppDataContainer, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "guid" == "type" or (self.guid is not self.__undef__ and (not (dirty and not self._guid[1]))):
            dct["guid"] = dictify(self.guid)
        if "toolkit" == "type" or (self.toolkit is not self.__undef__ and (not (dirty and not self._toolkit[1]))):
            dct["toolkit"] = dictify(self.toolkit)
        if "runtime" == "type" or (self.runtime is not self.__undef__ and (not (dirty and not self._runtime[1]))):
            dct["runtime"] = dictify(self.runtime)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._guid = (self._guid[0], True)
        self._toolkit = (self._toolkit[0], True)
        self._runtime = (self._runtime[0], True)

    def is_dirty(self):
        return any([self._guid[1], self._toolkit[1], self._runtime[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, AppDataContainer):
            return False
        return super(AppDataContainer, self).__eq__(other) and \
               self.guid == other.guid and \
               self.toolkit == other.toolkit and \
               self.runtime == other.runtime

    def __ne__(self, other):
        return not self.__eq__(other)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def guid(self):
        """
        A global identifier for this container, including across Delphix
        Engines.

        :rtype: ``basestring``
        """
        return self._guid[0]

    @guid.setter
    def guid(self, value):
        self._guid = (value, True)

    @property
    def toolkit(self):
        """
        The toolkit managing the data in the container.

        :rtype: ``basestring``
        """
        return self._toolkit[0]

    @toolkit.setter
    def toolkit(self, value):
        self._toolkit = (value, True)

    @property
    def runtime(self):
        """
        Runtime properties of this container.

        :rtype: :py:class:`delphixpy.web.vo.AppDataContainerRuntime`
        """
        return self._runtime[0]

    @runtime.setter
    def runtime(self, value):
        self._runtime = (value, True)

