#
# Copyright 2018 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-host-configuration.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.TypedObject import TypedObject
from delphixpy import factory
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

_UNDEFINED = __Undef()

class HostConfiguration(TypedObject):
    """
    *(extends* :py:class:`delphixpy.web.vo.TypedObject` *)* The representation
    of the host configuration properties.
    """
    def __init__(self, undef_enabled=True):
        super(HostConfiguration, self).__init__()
        self._type = ("HostConfiguration", True)
        self._discovered = (self.__undef__, True)
        self._machine = (self.__undef__, True)
        self._last_refreshed = (self.__undef__, True)
        self._operating_system = (self.__undef__, True)
        self._last_updated = (self.__undef__, True)

    API_VERSION = "1.10.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(HostConfiguration, cls).from_dict(data, dirty, undef_enabled)
        obj._discovered = (data.get("discovered", obj.__undef__), dirty)
        if obj._discovered[0] is not None and obj._discovered[0] is not obj.__undef__:
            assert isinstance(obj._discovered[0], bool), ("Expected one of [u'boolean'], but got %s" % type(obj._discovered[0]))
            common.validate_format(obj._discovered[0], "None", None, None)
        if "machine" in data and data["machine"] is not None:
            obj._machine = (factory.create_object(data["machine"], "HostMachine"), dirty)
            factory.validate_type(obj._machine[0], "HostMachine")
        else:
            obj._machine = (obj.__undef__, dirty)
        obj._last_refreshed = (data.get("lastRefreshed", obj.__undef__), dirty)
        if obj._last_refreshed[0] is not None and obj._last_refreshed[0] is not obj.__undef__:
            assert isinstance(obj._last_refreshed[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._last_refreshed[0]))
            common.validate_format(obj._last_refreshed[0], "None", None, None)
        if "operatingSystem" in data and data["operatingSystem"] is not None:
            obj._operating_system = (factory.create_object(data["operatingSystem"], "HostOS"), dirty)
            factory.validate_type(obj._operating_system[0], "HostOS")
        else:
            obj._operating_system = (obj.__undef__, dirty)
        obj._last_updated = (data.get("lastUpdated", obj.__undef__), dirty)
        if obj._last_updated[0] is not None and obj._last_updated[0] is not obj.__undef__:
            assert isinstance(obj._last_updated[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._last_updated[0]))
            common.validate_format(obj._last_updated[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(HostConfiguration, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "discovered" == "type" or (self.discovered is not self.__undef__ and (not (dirty and not self._discovered[1]))):
            dct["discovered"] = dictify(self.discovered)
        if "machine" == "type" or (self.machine is not self.__undef__ and (not (dirty and not self._machine[1]))):
            dct["machine"] = dictify(self.machine)
        if "last_refreshed" == "type" or (self.last_refreshed is not self.__undef__ and (not (dirty and not self._last_refreshed[1]))):
            dct["lastRefreshed"] = dictify(self.last_refreshed)
        if "operating_system" == "type" or (self.operating_system is not self.__undef__ and (not (dirty and not self._operating_system[1]))):
            dct["operatingSystem"] = dictify(self.operating_system)
        if "last_updated" == "type" or (self.last_updated is not self.__undef__ and (not (dirty and not self._last_updated[1]))):
            dct["lastUpdated"] = dictify(self.last_updated)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._discovered = (self._discovered[0], True)
        self._machine = (self._machine[0], True)
        self._last_refreshed = (self._last_refreshed[0], True)
        self._operating_system = (self._operating_system[0], True)
        self._last_updated = (self._last_updated[0], True)

    def is_dirty(self):
        return any([self._discovered[1], self._machine[1], self._last_refreshed[1], self._operating_system[1], self._last_updated[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, HostConfiguration):
            return False
        return super(HostConfiguration, self).__eq__(other) and \
               self.discovered == other.discovered and \
               self.machine == other.machine and \
               self.last_refreshed == other.last_refreshed and \
               self.operating_system == other.operating_system and \
               self.last_updated == other.last_updated

    def __ne__(self, other):
        return not self.__eq__(other)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def discovered(self):
        """
        Indicates whether the host configuration properties were discovered.

        :rtype: ``bool``
        """
        return self._discovered[0]

    @discovered.setter
    def discovered(self, value):
        self._discovered = (value, True)

    @property
    def machine(self):
        """
        The host machine information.

        :rtype: :py:class:`delphixpy.web.vo.HostMachine`
        """
        return self._machine[0]

    @machine.setter
    def machine(self, value):
        self._machine = (value, True)

    @property
    def last_refreshed(self):
        """
        The timestamp when the host was last refreshed.

        :rtype: ``basestring``
        """
        return self._last_refreshed[0]

    @last_refreshed.setter
    def last_refreshed(self, value):
        self._last_refreshed = (value, True)

    @property
    def operating_system(self):
        """
        The host operating system information.

        :rtype: :py:class:`delphixpy.web.vo.HostOS`
        """
        return self._operating_system[0]

    @operating_system.setter
    def operating_system(self, value):
        self._operating_system = (value, True)

    @property
    def last_updated(self):
        """
        The timestamp when the host was last updated.

        :rtype: ``basestring``
        """
        return self._last_updated[0]

    @last_updated.setter
    def last_updated(self, value):
        self._last_updated = (value, True)

